<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers:username,password,destination");
include("conn.php");
include("functions.php");
$response = array();
$response["status"] = false;
$response["message"] = "Un Authorized";
$headers = getallheaders();
$myUserName =isset($headers["Username"])?$headers["Username"]:$headers["username"];
$myPassword =isset($headers["Password"])?$headers["Password"]:$headers["password"];
$myUserName = mysqli_real_escape_string($conn,$myUserName);
$myPassword =   mysqli_real_escape_string($conn,$myPassword);
$type = $_GET["type"];
if($type=="vehiclesetupjoiningfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `vehiclesetup` SET `JoiningFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The joining fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The joining fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for joining fee";
	}
}
else if($type=="vehiclesetupdailyfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `vehiclesetup` SET `DailyFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The daily fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The daily fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for daily fee";
	}
}
else if($type=="vehiclesetupmonthlyfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `vehiclesetup` SET `MonthlyFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The monthly fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The monthly fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for monthly fee";
	}
}else if($type=="vehiclesetupnoobjectionfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `vehiclesetup` SET `NoObjectionFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The no objection fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The no objection fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for monthly fee";
	}
}
else if($type=="membersetupjoiningfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `membersetup` SET `JoiningFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The joining fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The joining fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for joining fee";
	}
}
else if($type=="membersetupdailyfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `membersetup` SET `DailyFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The daily fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The daily fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for daily fee";
	}
}
else if($type=="membersetupmonthlyfee"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `membersetup` SET `MonthlyFee`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The monthly fee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The monthly fee could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for monthly fee";
	}
}else if($type=="savingswithdrawalcharge"){
	$amount = trim($_POST["amount"]);
	if(is_numeric($amount)){
		$sql= "UPDATE `membersetup` SET `savingswithdrawalcharge`=?";
		$values = array($amount);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The Savings Withdrawal Charge was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The Savings Withdrawal Charge could not be updated. Please try again later";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "Please specify a valid value for Savings Withdrawal Charge";
	}
}
else if($type=="customerreceipts"){
	
}
else if($type=="pettycashvoucher"){
	if(isset($_POST["pcvNo"])){
	    // 
		$pcvNo = trim($_POST["pcvNo"]);
		$region = trim($_POST["region"]);
		$salesRep = trim($_POST["salesRep"]);
		
		$bankCode = trim($_POST["bankCode"]);
		$pcvDate = trim($_POST["pcvDate"]);
		$refNo = trim($_POST["refNo"]);
		$payee = trim($_POST["payee"]);
		
		//check exists
		$tPcvNo = mysqli_real_escape_string($conn, $pcvNo);
		$check = "SELECT * FROM `pettycashvouchers` where pcvNo = '$tPcvNo'";
		$checkRes = mysqli_query($conn, $check);
		if(mysqli_num_rows($checkRes)>0){ //exists, update
		$sql = "UPDATE `pettycashvouchers` SET `regionCode`=?,`salesRep`=?,`bank`=?,`externalRef`=?, `pcvDate`= ?,`payee`=? WHERE `pcvNo` = ? and `posted` = 0";
		$values = array($region,$salesRep,$bankCode,$refNo,$pcvDate,$payee,$pcvNo);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The petty cash voucher was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The petty cash voucher could not be updated";
			}
			
		}else{//insert
			$sql = "INSERT INTO `pettycashvouchers`(`pcvNo`,`regionCode`,`salesRep`, `bank`, `pcvDate`, `externalRef`,`payee`,`posted`, `createdOn`, `createdBy`) VALUES (?,?,?,?,?,?,?,0,NOW(),?)";
			$values = array($pcvNo,$region,$salesRep,$bankCode,$pcvDate, $refNo,$payee,$myUserName);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The petty cash voucher was successfully created";
				$response["overLoad1"] = $pcvNo;
				$getDate = "select * from pettycashvouchers where pcvNo = '$tPcvNo'";
				$dateRes = mysqli_query($conn, $getDate);
				while($dateDetails = mysqli_fetch_assoc($dateRes)){
					$myDate = explode(" ",$dateDetails["createdOn"] );
					$response["overLoad2"] =$myDate[0];
				}
				
			}else{
				$response["status"] = false;
				$response["message"] = "The petty cash voucher could not be created";
			}
		}
	}
}
else if($type=="pcvlines"){
	$code = trim($_POST["code"]);
	$amount = trim($_POST["amount"]);
	$pcvNo = trim($_POST["pcvNo"]);
	$tPcvNo = mysqli_real_escape_string($conn,$pcvNo);
	$checkSql = "SELECT * FROM `pettycashvouchers` where pcvNo  ='$tPcvNo' and posted = 0";
	$checkRes = mysqli_query($conn, $checkSql);
	if(mysqli_num_rows($checkRes)>0){
		$sql = "UPDATE `pettycashvoucherlines` SET `amount` = ? WHERE id = ? and pcvNo = ?";
		$values = array($amount,$code,$pcvNo);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The line was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The line could not be updated";
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A petty cash voucher with the given no does not exist \n or has already been posted";
	}
}
else if($type=="updateuser"){
	$userName = trim($_POST["userName"]);
	$fullName = trim($_POST["fullName"]);
	$emailAddress = trim($_POST["emailAddress"]);
	$phoneNumber = trim($_POST["phoneNumber"]);
	$password = trim($_POST["password"]);
	
	$roleId = trim($_POST["roleId"]);
	$employeeAccount = trim($_POST["employeeAccount"]);
	$receivablesAccount = trim($_POST["receivablesAccount"]);
	$warehouse = trim($_POST["warehouse"]);
	$pricingGroup = trim($_POST["pricingGroup"]);
	$defaultBank = trim($_POST["defaultBank"]);
                    
	//username is required
	//username atleast 4 characters
	//full name is required
	//password is required
	//password minimum 4 characters
	$error = false;
	$message = "";
	if($userName==""){
		$message = "Username is required";
		$error = true;
	}
	if(strlen($userName)<4){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Username must be atleast 4 characters";
		$error = true;
	}
	if($fullName==""){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Fullname is required";
		$error = true;
	}

	if(strlen($password)>0&&strlen($password)<4){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Password must be atleast 4 characters";
		$error = true;
	}
	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{
		//update
		if(strlen($password)>0){
		    $password = hash("sha256", $password);
		    $sql = "UPDATE `users` SET `fullname` = ?, `email` = ?, `phone`=?,`roleId`=?, `employee_code`=?, `store_location`=?, `receivables_acccount`=?, `pricing_group`=?, `default_bank`=?,`Password`=? where username = ?";
		    $values = array($fullName,$emailAddress,$phoneNumber,$roleId,$employeeAccount,$warehouse,$receivablesAccount,$pricingGroup,$defaultBank,$password,$userName);
		    
	    
		    if(pdoExecute($sql, $values)){			
		    	$response["status"] = true;
		    	$response["message"] = "The User was successfully Updated";
		    }else{			
		    	$response["status"] = false;
		    	$response["message"] = "The User could not be Updated";
		    }
		}else{
		    $sql = "UPDATE `users` SET `fullname` = ?, `email` = ?, `phone`=?,`roleId`=?, `employee_code`=?, `store_location`=?, `receivables_acccount`=?, `pricing_group`=?, `default_bank`=? where username = ?";
		    $values = array($fullName,$emailAddress,$phoneNumber,$roleId,$employeeAccount,$warehouse,$receivablesAccount,$pricingGroup,$defaultBank,$userName);
		    
	    
		    if(pdoExecute($sql, $values)){			
		    	$response["status"] = true;
		    	$response["message"] = "The User was successfully Updated";
		    }else{			
		    	$response["status"] = false;
		    	$response["message"] = "The User could not be Updated";
		    }
		    
		}
	}
}
else if ($type=="appForgotPassword"){
    $idNo = "";
    $emailAddress = "";
    $error = false;
    $message = "";
    if(isset($_POST["idNo"])){
        $idNo = trim($_POST["idNo"]);
    }else{
        $error = false;
        $message = "Please include all required fields";
    }
    if(isset($_POST["emailAddress"])){
        $emailAddress = trim($_POST["emailAddress"]);
    }else{
        $error = false;
        $message = "Please include all required fields";
    }
    if(!$error){
        if(strlen($idNo)<6){
            $error = false;
            $message = "Please provide a valid Id No";
        }
        if(strlen($emailAddress)<6){
            $error = false;
            $message = "Please provide a valid email address";
        }
    }
    if($error){
        $response["status"] = false;
	    $response["message"] = $message;
    }else{
        $idNo = mysqli_real_escape_string($conn, $idNo);
        $emailAddress = mysqli_real_escape_string($conn, $emailAddress);
        //check registered users
        $sql = "SELECT * FROM `mobileappusers` WHERE idNo='$idNo' and emailAddress='$emailAddress'";
        $res = mysqli_query($conn,$sql);
        $records = mysqli_num_rows($res);
        if($records==1){
            while($result=mysqli_fetch_assoc($res)){
                $phoneNumber = $result["phoneNumber"];
                $password = rand(1000,9999);
                $textMessage="Dear ".$result["userType"].", We have received your password reset request. Please use the password $password to login";
                $encPass = hash("sha256",$password);
                $update = "update mobileappusers set password= ?, changePassword=? where idNo=? and emailAddress=?";
                $values = array($encPass,1,$idNo,$emailAddress);
                if(pdoExecute($update,$values)){
                    sendTextMessage($phoneNumber, $textMessage);
                    $response["status"] = true;
	                $response["message"] = "We have sent a one time password to your phone number. Please use it to login to your account";
                }else{
                    	$response["status"] = false;
	                    $response["message"] = "Your password could not be updated. Please try again later";
                }
            }
            
        }else{
            //no record, try first time registration
            // $sql = "SELECT COUNT(MemberNo) noOfClients,
            // (select COUNT(vendorNumber) from vendors WHERE idNo='$idNo' and email='$emailAddress' and vendortype='Investor') noOfInvestors,
            // (select COUNT(vendorNumber) from vendors WHERE idNo='$idNo' and email='$emailAddress' and vendortype='Sales Rep') noOfSalesRep 
            // FROM members WHERE IdNo= '$idNo' and Email = '$emailAddress' ";
            
            $sql = "SELECT COUNT(`customerNumber`) noOfClients,
                (SELECT COUNT(`vendorNumber`) FROM `vendors` WHERE `idNo`='$idNo' AND `email`='$emailAddress' AND `vendortype`='Sales Rep') noOfSalesRep 
                FROM `customers` WHERE `IdNo`= '$idNo' AND `Email` = '$emailAddress' ";
            
            $res = mysqli_query($conn,$sql);
            while($result = mysqli_fetch_assoc($res)){
                $error = false;
                $message="";
                $noOfClients = $result["noOfClients"];
                $noOfInvestors = $result["noOfInvestors"];
                $noOfSalesRep = $result["noOfSalesRep"];
                $accountType = "";//'Investor', 'Client', 'Sales Rep'
               
                $phoneNumber = "";
                $phoneSql="";
                if($noOfClients==1){
                    $phoneSql = "select * FROM `customers` WHERE IdNo= '$idNo' and Email = '$emailAddress'";
                    $accountType="Client";
                }else if($noOfSalesRep==1){
                    $phoneSql = "select * from vendors WHERE idNo='$idNo' and email='$emailAddress' and vendortype='Sales Rep'";
                    $accountType="Sales Rep";
                }else{
                    $error = true;
                    $message="An account with the selected credentials does not exist. Please contact support";
                }
                if($error){
                   $response["status"] = false;
	               $response["message"] = $message; 
                }else{
                    $accountNo = "";
                    $firstName = "";
                    $middleName = "";
                    $lastName = "";
                    $phoneRes = mysqli_query($conn,$phoneSql);
                    while($phoneResult = mysqli_fetch_assoc($phoneRes)){
                       // print_r($phoneResult);
                        $phoneNumber = $phoneResult["phoneNumber"];
                        $accountNo = $accountType == "Client" ? $phoneResult["customerNumber"] : $phoneResult["vendorNumber"];
                        $firstName = $phoneResult["firstName"];
                        $middleName = $phoneResult["middleName"];
                        $lastName = $phoneResult["lastName"];
                    }
                    $fullName = $firstName . $middleName . $lastName;
                    $password = rand(1000,9999);
                    $textMessage="Dear $accountType, We have received your account creation request. Please use the password $password to login";
                    $encPass = hash("sha256",$password);
                    $sql = "INSERT INTO `mobileappusers`(`idNo`, `emailAddress`, `userName`, `fullName`, `phoneNumber`, `accountNo`,`userType`, `password`, `createdOn`, `changePassword`) 
                        VALUES (?,?,?,?,?,?,?,?,NOW() + INTERVAL 7 HOUR,1)";
                    $values = array($idNo,$emailAddress,$idNo,$fullName,$phoneNumber,$accountNo,$accountType,$encPass);
                    if(pdoExecute($sql,$values)){
                        sendTextMessage($phoneNumber, $textMessage);
                        $response["status"] = true;
    	                $response["message"] = "We have sent a one time password to your phone number. Please use it to login to your account";
                    }else{
                        	$response["status"] = false;
    	                    $response["message"] = "Your Account could not be created. Please try again later";
                    }
                    
                }
                
            }
        }
    }
}
else if ($type=="appUpdatePassword"){
    //if ($_SERVER['REQUEST_METHOD']=='POST') {
    if(isset($_POST["accountNo"])&&isset($_POST["currentPassword"])&&isset($_POST["newPassword"])&&isset($_POST["confirmNewPassword"]))
    $accountNo = trim($_POST["accountNo"]);
    $tAccountNo = mysqli_real_escape_string($conn, $accountNo);
    $currentPassword =trim($_POST["currentPassword"]);
    $newPassword =trim($_POST["newPassword"]);
    $confirmNewPassword = trim($_POST["confirmNewPassword"]);
    if($newPassword==$confirmNewPassword){
        if(strlen($newPassword)<4){
            $response["status"] =0;
            $response["message"] ="Your new password must be atleast four(4) characters";
        }/*else if(!preg_match("#[a-z]+#",$newPassword)){
            $response["status"] =0;
            $response["message"] ="Your new password must contain at least one lower case";
        }else if(!preg_match("#[A-Z]+#",$newPassword)){
            $response["status"] =0;
            $response["message"] ="Your new password must contain at least one upper case";
        }else if(!preg_match("#[A-Z]+#",$newPassword)){
            $response["status"] =0;
            $response["message"] ="Your new password must contain at least one upper case";
        }else if(!preg_match("#[0-9]+#",$newPassword)){
            $response["status"] =0;
            $response["message"] ="Your new password must contain at least one digit";
        }else if(!preg_match("/[\'^£$%&*()}{@#~?><>,|=_+!-]/",$newPassword)){
            $response["status"] =0;
            $response["message"] ="Your new password must contain at least one special character";
        }*/else{
            $encrypredCurrentPassword = hash("sha256",$currentPassword);
            $check = "select * from mobileappusers where accountNo ='$tAccountNo' and password = '$encrypredCurrentPassword'";
            $checkRes = mysqli_query($conn, $check);
            $checkNum = mysqli_num_rows($checkRes);
            if($checkNum==1){
                $update = "update mobileappusers set password=?, changePassword=? where accountNo=?";
                $encryptedNewPassword = hash("sha256",$newPassword);
                $values = array($encryptedNewPassword,0,$accountNo);
                if(pdoExecute($update, $values)){
                    $response["status"] = true;
                    $response["message"] ="Your Password was successfully updated";
                }else{
                    $response["status"] = false;
                    $response["message"] ="Your Password could not be updated";
                }
            }else{
                $response["status"] = false;
                $response["message"] ="Invalid Current Password";
            }
        }
    }else{
        $response["status"] = false;
        $response["message"] ="New password must be the same as confirm new password";
    }


    //}
    
}
else if($type=="blockUser"){
	$userName = trim($_POST["user"]);
	$sql = "update users set status =0 where username = ?";
	$values = array($userName);
		if(pdoExecute($sql, $values)){			
			$response["status"] = true;
			$response["message"] = "The User was successfully Blocked";
		}else{			
			$response["status"] = false;
			$response["message"] = "The User could not be Blocked";
		}
}
else if($type=="activateUser"){
	$userName = trim($_POST["user"]);
	$sql = "update users set status =1 where username = ?";
	$values = array($userName);
		if(pdoExecute($sql, $values)){			
			$response["status"] = true;
			$response["message"] = "The User was successfully Activated";
		}else{			
			$response["status"] = false;
			$response["message"] = "The User could not be Activated";
		}
}
else if($type=="updateinvestments"){
    
    $invNo = $_POST["invNo"];
    $desc = $_POST["desc"];
    $startDate = $_POST["startDate"];
    
    $sql = "update allinvestments set investmentNo ='$invNo' ,description='$desc',startDate='$startDate' where investmentNo = '$invNo'";
    
    $response = array();
    if(mysqli_query($conn, $sql)){
    $response["status"] = true;
        $response["message"] = "Investment details were successfully updated";	
    }else{
        $response["status"] = false;
        $response["message"] = "Investment details could not be updated. Please try again";
    }
}
else if($type=="vehicle"){
	$fleetNumber = mysqli_real_escape_string($conn, trim($_POST["fleetNumber"]));
	$tregNo = mysqli_real_escape_string($conn, trim($_POST["regNo"]));
	$makeCode = mysqli_real_escape_string($conn, trim($_POST["makeCode"]));
	$modelCode = mysqli_real_escape_string($conn, trim($_POST["modelCode"]));
	$vAlias = mysqli_real_escape_string($conn, trim($_POST["vAlias"]));
	$ownerCode = mysqli_real_escape_string($conn, trim($_POST["ownerCode"]));
	$brandCode = mysqli_real_escape_string($conn, trim($_POST["brandCode"]));
	$active = mysqli_real_escape_string($conn, trim($_POST["active"]));
	$photo = $_POST["photo"];
	//check no other vehicle with same regNo
	$sql= "Update `vehicles` set `FleetNumber`='$fleetNumber', `Make`='$makeCode', `Model` = '$modelCode', `Name(alias)`='$vAlias', `Photo`='$photo', `Owner` = '$ownerCode', `brand`='$brandCode', `active`=$active  where RegNo = '$tregNo'";
	if(mysqli_query($conn, $sql)){
		$response["status"] = true;
		$response["message"] = "Vehicle was successfully updated";
	}else{
		$response["status"] = false;
		$response["message"] = "Vehicle could not be updated";
	}
}
else if($type=="numberseries"){
	if(isset($_POST["name"])&&isset($_POST["prefix"])&&isset($_POST["length"])&&isset($_POST["lastNumber"])&&isset($_POST["code"])){
		$name = mysqli_real_escape_string($conn, trim($_POST["name"]));
		$prefix = mysqli_real_escape_string($conn, trim($_POST["prefix"]));
		$length = mysqli_real_escape_string($conn, trim($_POST["length"]));
		$lastNumber = mysqli_real_escape_string($conn, trim($_POST["lastNumber"]));
		$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
		$update = "update numberseries set  name = '$name', prefix='$prefix', length='$length', lastNumberUsed='$lastNumber' where code = '$code'";
		if(mysqli_query($conn,$update)){
			$response["status"] = true;
		$response["message"] ="Number series was successfully updated";
		}
	}
}
else if($type=="departments"){
	$departmentName  = trim($_POST["departmentName"]);
	$code  = trim($_POST["code"]);
	if($departmentName==""){
			$response["status"] = false;
			$response["message"] ="Please indicate the department name";
	}else{
		$sql = "SELECT * FROM `departments` WHERE `department_name` = ? and NOT code ? ";
		$res =fetchWithPdo($sql,array($departmentName,$code));
		if(count($res)>0){
			$response["status"] = false;
			$response["message"] ="There is another department with the same name.";
		}else{
			$updateDepartment = "UPDATE `departments` SET `department_name` = ? WHERE code = ?";
			$values = array($departmentName, $code);
			if(pdoExecute($updateDepartment,$values)){
				$response["status"] = true;
				$response["message"] ="The department was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] ="The department could not be updated";
				}
			}
		}
}
else if($type=="employees"){
	$fName =  trim($_POST["fName"]);	
	$lName =  trim($_POST["lName"]);	
	$mName =  trim($_POST["mName"]);	
	$idNumber =  trim($_POST["idNumber"]);	
	$phoneNumber =  trim($_POST["phoneNumber"]);	
	$payrollNumber =  trim($_POST["payrollNumber"]);	
	$email =  trim($_POST["email"]);	
	$dob =  trim($_POST["dob"]);	
	$disabled =  trim($_POST["disabled"]);	
	$disabilityDescription =  trim($_POST["disabilityDescription"]);	
	$kra =  trim($_POST["kra"]);	
	$nssf =  trim($_POST["nssf"]);	
	$nhif =  trim($_POST["nhif"]);	
	$department =  trim($_POST["department"]);	
	$employmentTerms =  trim($_POST["employmentTerms"]);	
	
	$jobTitle =  trim($_POST["jobTitle"]);	
	$hod =  trim($_POST["hod"]);	
	$employeeNumber =  trim($_POST["employeeNumber"]);	
	$photo = trim($_POST["photo"]);	
	$bank = "";
	$bankBranch = "";
	$bankAccount = "";
	$basicSalary = 0;
	$paysPAYE = 0;
	$paysNHIF = 0;
	$paysNSSF = 0;
	$suspendPay = 0;
	$deductHousingLevy = 0;
	$paysNita=0;
	if(isset($_POST["bank"])){
		$bank =  trim($_POST["bank"]);
	}if(isset($_POST["bankBranch"])){
		$bankBranch =  trim($_POST["bankBranch"]);
	}if(isset($_POST["bankAccount"])){
		$bankAccount =  trim($_POST["bankAccount"]);
	}if(isset($_POST["basicSalary"])){
		$basicSalary =  trim($_POST["basicSalary"]);
	}if(isset($_POST["paysPAYE"])){
		$paysPAYE =  trim($_POST["paysPAYE"]);
	}if(isset($_POST["paysNHIF"])){
		$paysNHIF =  trim($_POST["paysNHIF"]);
	}if(isset($_POST["paysNSSF"])){
		$paysNSSF =  trim($_POST["paysNSSF"]);
	}if(isset($_POST["suspendPay"])){
		$suspendPay =  trim($_POST["suspendPay"]);
	}
	if(isset($_POST["deductHousingLevy"])){
		$deductHousingLevy =  trim($_POST["deductHousingLevy"]);
	}
	if(isset($_POST["paysNITA"])){
		$paysNita =  trim($_POST["paysNITA"]);
	}
	
	$error = false;
	$message = "";
	if($fName==""){
		$message.= $message==""?"":"\n";
		$error = true;
		$message .= "Please specify the employees first name";
	}if($lName==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees last name";
	}if($idNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees Id Number";
	}if($phoneNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees phone Number";
	}
	$gender =  trim($_POST["gender"]);	
	$goodConduct =  trim($_POST["goodConduct"]);	

	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{
		
		$sql = "update `employee` set `first_name` = ?, `middle_name`= ?, `last_name`=?, `IdNumber`=?, `payroll_number`= ?,`date_of_birth`=?, `Pin`=?, `PhoneNumber`=?, `Email`=?, `disabled`=?, `disability_description`=?,`employment_terms`=?,`department` = ?, `job_title`=?, `hod`=?, `NHIFNo`=?, `NSSFNo`=?, `Photo`=?
				,`Bank`= ?,`BankBranch`= ?,`AccountNumber`= ?,`BasicSalary`= ?,`PaysPaye`= ?,`paysNHIF`= ?,`paysNSSF`= ?,	`deduct_housing_levy`=?, `pays_nita`=?,`suspendPay`= ?, gender = ?, good_conduct = ? where EmployeeNumber = ?";
        $values = array($fName,$mName,$lName,$idNumber,$payrollNumber,$dob,$kra,$phoneNumber,$email,$disabled,$disabilityDescription,$employmentTerms,$department,$jobTitle,$hod,$nhif,$nssf,$photo,$bank,$bankBranch,$bankAccount,$basicSalary,$paysPAYE,$paysNHIF,$paysNSSF,$deductHousingLevy,$paysNita,$suspendPay,$gender,$goodConduct,$employeeNumber);
		if(pdoExecute($sql,$values)){
			if($hod){
			$update = "update employee set hod = 0 where department = ? and hod =1 and not EmployeeNumber = ?";
			$update2 = "update departments set hod = ? where code = ?";
			pdoExecute($update,array($department,$employeeNumber));
			pdoExecute($update2,array($employeeNumber,$department));
			}
			$response["status"] = true;
			$response["message"] ="The employee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] ="The employee could not be updated";
		}
	}
}
else if($type=="leavetypes") {
	$description =  trim($_POST['description']);
	$gender = trim($_POST['gender']);
	$annual = $_POST['annual'];
	$includePublicHolidays = $_POST['includePublicHolidays'];
	$includeWeekends = $_POST['includeWeekends'];
	$minDays = $_POST['minDays'];
	$maxDays = $_POST['maxDays'];
	if (isset($_POST['no'])) {
		$no = $_POST['no'];
		$sel =fetchWithPdo("SELECT * FROM `leaveTypes` WHERE `no`=?",array($no));
		if (count($sel)>0) {
			$update = "UPDATE `leaveTypes` SET `description`=?,`gender`=?,`annual`=?,`includePublicHolidays`=?,`includeWeekends`=?,`minDays`=?,`maxDays`=? WHERE `no`=?";
			$values = array($description,$gender,$annual,$includePublicHolidays,$includeWeekends,$minDays,$maxDays,$no);
			if (pdoExecute($update,$values)) {
				$response["status"] = true;
				$response["message"] = "Leave type has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Leave type could not be updated";
			}
		}else{
			$response["status"] = false;
			$response["message"] = "Leave type could not be updated";
		}
	}
}
else if ($type=="leaveapplications") {
	$id =        trim($_POST['id']);
	$employee =  trim($_POST['employee']);
	$leaveType = trim($_POST['leaveType']);
	$startDate = trim($_POST['startDate']);
	$noOfDays =  trim($_POST['noOfDays']);
	$returnDate =trim($_POST['returnDate']);
	$leavePhone =trim($_POST['leavePhone']);
	$reliever1 = trim($_POST['reliever1']);
    $reliever2 = trim($_POST['reliever1']);
	$sel = "SELECT * FROM `leaveapplications` WHERE `id`=?";
	$res = fetchWithPdo($sel,array($id));
	if (count($res)>0) {#update
		$update = "UPDATE `leaveapplications` SET `employee`=?,`leaveType`=?,`startDate`=?,`noOfDays`=?,`returnDate`=?,`leavePhone`=?,`reliever1`=?,`reliever2`=? WHERE `id`=? ";
		$values = array($employee,$leaveType,$startDate,$noOfDays,$returnDate,$leavePhone,$reliever1,$reliever2,$id);
		if (pdoExecute($update,$values)) {
			$response["status"] = true;
			$response["message"] = "Application has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Application could not be updated";
		}
	}
}
else if($type=="disbursementmodes"){
	$id = trim($_POST["id"]);
	$mode = trim($_POST["mode"]);
	$error = false;
	$message = "";
	if(!is_numeric($id)){
		$error = true;
		$message.= "Wrong entry";
	}
	if(strlen($mode)<1){
		$error = true;
		if(strlen($message)>0){
		$message.="\n";
		}
		$message.= "Mode cannot be blank";
		
	}
	if($error){
		$response["status"] = false;
		$response["message"] = $message;
	}else{
		$sql = "";
		$mode = mysqli_real_escape_string($conn, $mode);
		if($id==0){
			$sql = "insert into loandisbursementmodes(id, mode) value ('','$mode')";
		}else{
			$sql = "update loandisbursementmodes set mode = '$mode' where id = $id";
		}
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "Disbursement mode was successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "Disbursement mode could not be updated. Please try again";
	}
	}
}
else if($type=="generalloanfees"){
	$defaultPenalty = trim($_POST["defaultPenalty"]);
	$withdrawalCharge = $_POST["withdrawalCharge"];
	$balancingCharge = $_POST["balancingCharge"];
	$crb = $_POST["crb"];
	$chequeCommission = $_POST["chequeCommission"];
	$loanForm = $_POST["loanForm"];
	$insurance = $_POST["insurance"];
	$graceperiod = $_POST["graceperiod"];
	$error = false;
	$message = "";

	if(!is_numeric($defaultPenalty)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Default penalty must be a numeric figure";
	}

	if(!is_numeric($withdrawalCharge)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Withdrawal charge must be a numeric figure";
	}
	if(!is_numeric($graceperiod)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Grace Period must be a numeric figure";
	}
	if(!is_numeric($balancingCharge)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Balancing charge must be a numeric figure";
	}
	if(!is_numeric($crb)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="CRB must be a numeric figure";
	}

	if(!is_numeric($chequeCommission)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Cheque commission must be a numeric figure";
	}
	if(!is_numeric($loanForm)){
	$error = true;
	if(strlen($message)>0){
		$message.="\n";
	}
	$message.="Loan form must be a numeric figure";
	}


	if($error){
		$response["status"] = false;
		$response["message"] = $message;
	}else{
		$sql = "select * from loangeneralfees where Id = 1";
		$res = mysqli_query($conn, $sql);
		if(mysqli_num_rows($res)>0){
				$sql = "update `loangeneralfees` set  `defaultpenalty` = '$defaultPenalty', `withdrawalcharge`='$withdrawalCharge', `crbcharge`='$crb', `chequecommission` = '$chequeCommission', `loanform` ='$loanForm', `insurance` = '$insurance',`balancingCharge` = '$balancingCharge', `graceperiod` ='$graceperiod'  where Id = 1";
		
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "General loan fees were successfully updated ";	
	}else{
		$response["status"] = false;
		$response["message"] = "General loan fees could not be updated. Please try again";
	}
		}else{
				$sql = "INSERT INTO `loangeneralfees`(`Id`, `defaultpenalty`, `withdrawalcharge`, `crbcharge`, `chequecommission`, `loanform`, `insurance`,`balancingCharge`,`graceperiod`) VALUES 
		('1','$defaultPenalty','$withdrawalCharge','$crb','$chequeCommission','$loanForm','$insurance','$balancingCharge','$graceperiod')";
		
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "General loan fees were successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "General loan fees could not be updated. Please try again";
	}
	}

	}
}

else if($type=="guarantors"){
	$guarantorId =mysqli_real_escape_string($conn, trim($_POST["guarantorId"]));
	$memberNumber =mysqli_real_escape_string($conn, trim($_POST["memberNumber"]));
	$loanNumber =mysqli_real_escape_string($conn, trim($_POST["loanNumber"]));
	$percentage =mysqli_real_escape_string($conn, trim($_POST["percentage"]));
	$amountToGuaraantee =mysqli_real_escape_string($conn, trim($_POST["amountToGuaraantee"]));
	$action =mysqli_real_escape_string($conn, trim($_POST["action"]));
	$sql = "";
	if($action=="delete"){
		$sql = "DELETE FROM `loanguarantors` WHERE `id` = '$guarantorId'";	
	}else{
		if($guarantorId==0){
			$sql = "INSERT INTO `loanguarantors`(`id`, `loan`, `member`, `amount_to_guarantee`, `percentage_to_guarantee`) VALUES 
			('','$loanNumber','$memberNumber','$amountToGuaraantee','$percentage')";
		}else{
			$sql = "UPDATE `loanguarantors` SET `loan`='$loanNumber',`member`='$memberNumber',`amount_to_guarantee`='$amountToGuaraantee',`percentage_to_guarantee`='$percentage' WHERE id = '$guarantorId'";
		}
	}
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "The guarantor was successfully added";	
	}else{
		$response["status"] = false;
		$response["message"] ="The guarantor could not be updated";
	}
}
else if($type=="members"){
	$memberNumber = trim($_POST["memberNumber"]);
	$fName = trim($_POST["fName"]);
	$mName = trim($_POST["mName"]);
	$lName = trim($_POST["lName"]);
	$idNo = trim($_POST["idNo"]);
	$phoneNo = trim($_POST["phoneNo"]);
	$email = trim($_POST["email"]);
	$pin = trim($_POST["pin"]);
	$sql = "update members set FirstName =? ,MiddleName=?,LastName=?,IdNo=?,PhoneNumber=?,Email=?,PIN=? where MemberNo = ? ";
	$values = array($fName,$mName,$lName,$idNo,$phoneNo,$email,$pin,$memberNumber);
	if(pdoExecute($sql, $values)){
		$response["status"] = true;
		$response["message"] = "Member details were successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "Member details could not be updated. Please try again";
	}
}
else if($type=="numberserieslastnumber"){
	if(isset($_POST["code"])&&is_numeric($_POST["code"])&&isset($_POST["lastNumber"])){
		$code = mysqli_real_escape_string($conn, trim($_POST["code"]));
		$lastNumber = mysqli_real_escape_string($conn, trim($_POST["lastNumber"]));
		$update = "UPDATE `numberseries` SET `lastNumberUsed`='$lastNumber' WHERE code ='$code'";
		mysqli_query($conn,$update);
	}
}
else if($type=="memberprofilephoto"){
	$memberNumber = $_POST["memberNumber"];
	$photo = $_POST["photo"];
	$sql = "update members set Photo = ? where MemberNo = ? ";
	$values = array($photo,$memberNumber);
	if(pdoExecute($sql, $values)){
	$response["status"] = true;
		$response["message"] = "Member photo was successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "Member photo could not be updated. Please try again";
	}
}
else if($type=="vendorprofilephoto"){
	$vendorNumber = $_POST["vendorNumber"];
	$photo = $_POST["photo"];
	$sql = "update vendors set vendorImage = ? where vendorNumber = ? ";
	$values = array($photo,$vendorNumber);
	if(pdoExecute($sql, $values)){
	$response["status"] = true;
		$response["message"] = "The vendor photo was successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "The vendor photo could not be updated. Please try again";
	}
}
else if($type=="customerprofilephoto"){
	$customerNumber = $_POST["customerNumber"];
	$photo = $_POST["photo"];
	//file_put_contents("customer.png",base64_decode($photo));
	$sql = "update customers set customerImage = ? where customerNumber = ? ";
	$values = array($photo,$customerNumber);
	if(pdoExecute($sql, $values)){
	$response["status"] = true;
		$response["message"] = "The customer photo was successfully updated";	
	}else{
		$response["status"] = false;
		$response["message"] = "The customer photo could not be updated. Please try again";
	}
}
else if($type=="chartofaccounts"){
	if(isset($_POST["accountNumber"])){
		$accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$currentStatus = mysqli_real_escape_string($conn, trim($_POST["currentStatus"]));
		$newStatus = mysqli_real_escape_string($conn, trim($_POST["newStatus"]));
		$sql = "update chartofaccounts set allowPosting = $newStatus where accountNumber = '$accountNumber' and allowPosting = $currentStatus";
		if(mysqli_query($conn, $sql)){
			$response["status"] = true;
			$response["message"] ="The account was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] ="The account could not be updated. Please try again later. ";
	}
	}
}
else if($type=="loancollateral"){
	$collateralId =mysqli_real_escape_string($conn, trim($_POST["collateralId"]));
	$regNumber =mysqli_real_escape_string($conn, trim($_POST["regNumber"]));
	$loanNumber =mysqli_real_escape_string($conn, trim($_POST["loanNumber"]));
	$vehicleValue =mysqli_real_escape_string($conn, trim($_POST["vehicleValue"]));
	$logBookReceived =mysqli_real_escape_string($conn, trim($_POST["logBookReceived"]));
	$action =mysqli_real_escape_string($conn, trim($_POST["action"]));
	$sql = "";
	if($action=="delete"){
		$sql = "DELETE FROM `loan_collateral` WHERE `id` = '$collateralId'";	
	}else{
		if($collateralId==0){
			$sql = "INSERT INTO `loan_collateral`(`id`, `loan`, `vehicle_no`, `vehicle_value`, `log_book_received`) VALUES 
			('','$loanNumber','$regNumber','$vehicleValue',$logBookReceived)";
		}else{
			$sql = "UPDATE `loan_collateral` SET `loan`='$loanNumber',`vehicle_no`='$regNumber',`vehicle_value`='$vehicleValue',`log_book_received`=$logBookReceived WHERE id = '$collateralId'";
		}
	}
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "The collateral was successfully added";	
	}else{
		$response["status"] = false;
		$response["message"] ="The collateral could not be updated";
	}
}
else if($type=="assetdetails"){
	$assetNo = $_POST["assetNo"];
	$Description = $_POST["Description"];
	$serial = $_POST["assetSerial"];
	$date = $_POST["dateAcquired"];
	$location = $_POST["location"];
	$assigned = $_POST["assignedTo"];
	$sql = "UPDATE `fixedassets` SET `Description` = '$Description', `Serial Number`='$serial',
	`Date Acquired`='$date',`Location` ='$location',`Assigned to` ='$assigned' WHERE `No`='$assetNo'";
	if(mysqli_query($conn, $sql)){
		$response["status"] = true;
			$response["message"] = "Asset details were successfully updated";	
		}else{
			$response["status"] = false;
			$response["message"] = "Asset details could not be updated. Please try again";
	   }
}
else if($type=="deactivateemployee"){
	$employeeNo = mysqli_real_escape_string($conn,trim($_POST["employeeNo"]));
	$sql = "select * from employee where EmployeeNumber = '$employeeNo'";
	$res = mysqli_query($conn,$sql);
	if(mysqli_num_rows($res)>0){
		$update = "update employee set exited = 1 where EmployeeNumber = '$employeeNo'";
		if(mysqli_query($conn,$update)){
			$response["status"] = true;
			$response["message"] ="The employee was successfully moved to inactive employees";
		}else{
			$response["status"] = false;
			$response["message"] ="The employee could not be updated";
		}
	}else{
		$response["status"] = false;
		$response["message"] ="The employee could not be found";
	}
}
else if($type=="transactiontype"){
	$transactionCode = trim($_POST["transactionCode"]);
	$transactionDescription = trim($_POST["transactionDescription"]);
	$accountNo = trim($_POST["accountNo"]);
	$enabled = trim($_POST["enabled"]);
	$showOnReceipt = trim($_POST["showOnReceipt"]);
	$showOnAgency = trim($_POST["showOnAgency"]);
	$journalAccountType = trim($_POST["journalAccountType"]);
	$tTransactionCode = mysqli_real_escape_string($conn, $transactionCode);
	$check = "select * from transactiontypes where Code = '$tTransactionCode'";
	$checkRes = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkRes)<1){
		$response["status"] = false;
		$response["message"] = "A transaction type with the entered code does not exist";
	}else{
		$sql = "update transactiontypes set `Description` = ?,`GLAccount` = ?,`enabled` = ?,`receipt`=?,`journalAccountType`= ?,`agency`= ? where `Code` = ?";
		$values = array($transactionDescription,$accountNo,$enabled,$showOnReceipt,$journalAccountType,$showOnAgency,$transactionCode);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The transaction type was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The transaction type could not be updated";
		}
	}
	
}
else if($type=="vendor"){
	$vendorNumber = trim($_POST["vendorNumber"]);
	$name = trim($_POST["name"]);
	$idNo = trim($_POST["idNo"]);
	$phoneNo = trim($_POST["phoneNo"]);
	$email = trim($_POST["email"]);
	$pin = trim($_POST["pin"]);
	$dob = trim($_POST["dob"]);
	$bankName = trim($_POST["bankName"]);
	$bankBranch = trim($_POST["bankBranch"]);
	$branchCode = trim($_POST["branchCode"]);
	$bankAccountNo = trim($_POST["bankAccountNo"]);
	//$photo = trim($_POST["photo"]);
	$postingGroup = trim($_POST["postingGroup"]);
	$vendorType = trim($_POST["vendorType"]);
	$region = trim($_POST["region"]);
	$contactPerson = trim($_POST["contactPerson"]);
	$contactPhone = trim($_POST["contactPhone"]);
	$contactPosition = trim($_POST["contactPosition"]);
	$contactEmailAddress = trim($_POST["contactEmailAddress"]);
	$remarks = trim($_POST["remarks"]);

	
	//check vendor exists
	$tVendorNo = mysqli_real_escape_string($conn, $vendorNumber);
	$sql = "SELECT * FROM `vendors` where vendorNumber = '$tVendorNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)<1){ //update
		$response["status"] = false;
		$response["message"] = "A vendor with the entered vendor number does not exist";
		
	}else{ //insert
		$sql = "update `vendors` set  `name`=?,`idNo`=?, `kraPin`=?, `dateofbirth`=?, `phoneNumber`=?, `email`=?, `vendorpostinggroup`=?, `bankName`=?, `bankBranch`=?, `branchCode`=?,`bankAccountNo`=?,`vendortype`=?,`regionCode`=?,`contactName`=?, `jobPosition`=?, `contactPhone`=?, `contactEmail`=?, `remarks`=? where `vendorNumber`=?";
		$values = array($name,$idNo,$pin, $dob, $phoneNo,$email,$postingGroup,$bankName,$bankBranch,$branchCode,$bankAccountNo,$vendorType,$region,$contactPerson,$contactPosition,$contactPhone,$contactEmailAddress,$remarks,$vendorNumber);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The vendor was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The vendor could not be updated";
		}
	}
}
else if($type=="customer"){
	if(isset($_POST["name"])&&isset($_POST["idNo"])&&isset($_POST["phoneNo"])&&isset($_POST["customerNo"])){
	    $custNo = trim($_POST["customerNo"]);
	    $customerName = trim($_POST["customerName"]);
	    $idNo =  trim($_POST["idNo"]);
	    $phoneNo =  trim($_POST["phoneNo"]);
		$kraPin=isset($_POST["kraPin"]) ? trim($_POST["kraPin"]) : "";
	    $pricingGroup = isset($_POST["pricingGroup"]) ? trim($_POST["pricingGroup"]) : 1;  
	    $creditLimit = isset($_POST["creditLimit"]) ? trim($_POST["creditLimit"]) : 0; 
	    $creditPeriod = isset($_POST["creditPeriod"]) ? trim($_POST["creditPeriod"]) : 0; 
		$customerEmail = isset($_POST["email"]) ? trim($_POST["email"]) : "";
		$location = isset($_POST["location"])?trim($_POST["location"]):"";
		$locationLatitude = isset($_POST["locationLatitude"])?trim($_POST["locationLatitude"]):0;
		$locationLongitude = isset($_POST["locationLongitude"])?trim($_POST["locationLongitude"]):0;
		$contactPerson = isset($_POST["contactPerson"])?trim($_POST["contactPerson"]):"";
		$contactPosition = isset($_POST["contactPosition"])?trim($_POST["contactPosition"]):"";
		$contactPhone = isset($_POST["contactPhone"])?trim($_POST["contactPhone"]):"";
		$contactEmail = isset($_POST["contactEmail"])?trim($_POST["contactEmail"]):"";
		$photo = isset($_POST["photo"])?trim($_POST["photo"]):"";
		$remarks = isset($_POST["remarks"])?trim($_POST["remarks"]):"";
		$salesAgent = isset($_POST["salesAgent"])?trim($_POST["salesAgent"]):"";
		$region = isset($_POST["region"])?trim($_POST["region"]):"";
		$postingGroup = isset($_POST["postingGroup"])?trim($_POST["postingGroup"]):0;
		$dob = isset($_POST["dateOfBirth"])?trim($_POST["dateOfBirth"]):null;
		if(strlen($dob)<1){
			$dob = null;
		}
	    $checkExists = "select * from customers where customerNumber = ?";
		$checkRes = fetchWithPdo($checkExists,array($custNo));
		if(count($checkRes)<1){
			$response["status"] = false;
			$response["message"] = "A customer with the selected customer No does not exists";
		}else{		
			$sql = "update `customers` set `customerName`=?, `idNo`=?, `kraPin`=?, `dateofbirth`=?, `phoneNumber`=?,`pricing_group`=?,`creditLimit`=?, `creditPeriod`=?,  `email`=?, `location`=?, `location_latitude`=?, `location_longitude`=?, `contactName`=?, `jobPosition`=?, `contactPhone`=?, `contactEmail`=?,  `customerpostinggroup`=?, `customerImage`=?, `salesAgent`=?, `region`=?,`remarks`=? where `customerNumber` = ?";
			$values = array();
			$values = array();
			array_push($values, $customerName);
			array_push($values, $idNo);
			array_push($values, $kraPin);
			array_push($values, $dob);
			array_push($values, $phoneNo);
			array_push($values, $pricingGroup);
			array_push($values, $creditLimit); 
			array_push($values, $creditPeriod);
			array_push($values, $customerEmail);
			array_push($values, $location);
			array_push($values, $locationLatitude);
			array_push($values, $locationLongitude);
			array_push($values, $contactPerson);
			array_push($values, $contactPosition);
			array_push($values, $contactPhone);
			array_push($values, $contactEmail);
			array_push($values, $postingGroup);
			array_push($values, $photo);
			array_push($values, $salesAgent);
			array_push($values, $region);
			array_push($values, $remarks);
			array_push($values, $custNo);
			if(pdoExecute($sql,$values)){
			    $response["status"] = true;
				$response["message"] = "The customer was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The customer could not be updated. Please try again";
			}
		}
	} else {
		$response["status"] = false;
		$response["message"] = "Please fill all mandatory fields";
	}

}
else if($type=="payrollemployees"){
    $employeeNumber =  trim($_POST["employeeNumber"]);
    $bank = "";
    $bankBranch = "";
    $bankAccount = "";
    $basicSalary = 0;
    $paysPAYE = 0;
    $paysNHIF = 0;
    $paysNSSF = 0;
    $paysNITA = 0;
    $deductHousingLevy = 0;
    $suspendPay = 0;
    if(isset($_POST["bank"])){
        $bank =  trim($_POST["bank"]);
    }if(isset($_POST["bankBranch"])){
        $bankBranch =  trim($_POST["bankBranch"]);
    }if(isset($_POST["bankAccount"])){
        $bankAccount =  trim($_POST["bankAccount"]);
    }if(isset($_POST["basicSalary"])){
        $basicSalary =  trim($_POST["basicSalary"]);
    }if(isset($_POST["paysPAYE"])){
        $paysPAYE =  trim($_POST["paysPAYE"]);
    }if(isset($_POST["paysNHIF"])){
        $paysNHIF =  trim($_POST["paysNHIF"]);
    }if(isset($_POST["paysNSSF"])){
        $paysNSSF =  trim($_POST["paysNSSF"]);
    }
    if(isset($_POST["paysNITA"])){
        $paysNITA =  trim($_POST["paysNITA"]);
    }if(isset($_POST["paysNITA"])){
        $paysNITA =  trim($_POST["paysNITA"]);
    }
    if(isset($_POST["deductHousingLevy"])){
        $deductHousingLevy =  trim($_POST["deductHousingLevy"]);
    }
    $error = false;
    $message = "";
    if($error){
        $response["status"] = false;
        $response["message"] =$message;
    }else{

        $sql = "update `employee` set `Bank`= ?,`BankBranch`= ?,`AccountNumber`= ?,`BasicSalary`= ?,`PaysPaye`= ?,`paysNHIF`= ?,`paysNSSF`= ?, `deduct_housing_levy`=?,`pays_nita` =?,`suspendPay`= ?		where EmployeeNumber = ?";
        $values = array($bank,$bankBranch,$bankAccount,$basicSalary,$paysPAYE,$paysNHIF,$paysNSSF,$deductHousingLevy,$paysNITA,$suspendPay,$employeeNumber);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
            $response["message"] ="The employee was successfully updated";
        }else{
            $response["status"] = false;
            $response["message"] ="The employee could not be updated";
        }
    }
}
else if($type=="salaryvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$month = trim($_POST["month"]);
	$year = trim($_POST["year"]);
	$bankCode = "";//trim($_POST["bankCode"]);
	$disbursementDate = "0000-00-00";//trim($_POST["disbursementDate"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$check = "SELECT * FROM `salaryvouchers` WHERE `voucherNo` = '$tVoucherNo'";
	$checkRes = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkRes)>0){//update
		while($result = mysqli_fetch_assoc($checkRes)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The salary voucher has already been posted and cannot be edited";
			}else{
				$sql = "update `salaryvouchers` set `month` = ?, `year` = ?, `payingBank` = ?, `disbursement_date` = ? where `voucherNo` = ? and `posted` = ?";
				$values = array($month, $year,$bankCode,$disbursementDate, $voucherNo, 0 );
				if(pdoExecute($sql,$values)){
						$response["status"] = true;
						$response["message"] = "The salary voucher was successfully updated";
				}else{
						$response["status"] = false;
						$response["message"] = "The salary voucher could not be updated";
				}
			}
		}
	}
}

else if($type=="payrolldeductions"){
	$deductionCode = trim($_POST["deductionCode"]);
	$deductionName = trim($_POST["deductionName"]);
	$deductionVendor = trim($_POST["deductionVendor"]);
	$taxable = trim($_POST["taxable"]);
	$disabled = trim($_POST["disabled"]);
	$tDeductionCode = mysqli_real_escape_string($conn, $deductionCode);
	//check exists
	$sql = "SELECT * FROM `allowancesdeductions` WHERE `code` = '$tDeductionCode' and `type` = 0";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){//exists, update
		$sql = "update `allowancesdeductions` set `name` = ?, `vendorGlAccount` = ?, `taxable` = ?, `disabled` = ?, `type` = ?, `statutory` = ? where `code` = ? and `type` = ? ";
		$values = array($deductionName,$deductionVendor,$taxable,$disabled, 0, 0, $deductionCode,0);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The deduction was successfully \n updated";
		}else{
				$response["status"] = false;
				$response["message"] = "The deduction could not be \n updated";
		}
	}
}

else if($type=="payrollallowances"){
	$allowanceCode = trim($_POST["allowanceCode"]);
	$allowanceName = trim($_POST["allowanceName"]);
	$allowanceGLAccount = trim($_POST["allowanceGLAccount"]);
	$taxable = trim($_POST["taxable"]);
	$disabled = trim($_POST["disabled"]);
	$tAllowanceCode = mysqli_real_escape_string($conn, $allowanceCode);
	//check exists
	$sql = "SELECT * FROM `allowancesdeductions` WHERE `code` = '$tAllowanceCode' and `type` = 1";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){//exists, update
		$sql = "update `allowancesdeductions` set `name` = ?, `vendorGlAccount` = ?, `taxable` = ?, `disabled` = ?, `type` = ?, `statutory` = ? where `code` = ? and `type` = ? ";
		$values = array($allowanceName,$allowanceGLAccount,$taxable,$disabled, 1, 0, $allowanceCode,1);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The allowance was successfully \n updated";
		}else{
				$response["status"] = false;
				$response["message"] = "The allowance could not be \n updated";
		}
	}
}

else if($type=='salaryadvances'){
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
    $sel = "SELECT * FROM `salaryadvance` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select)>0) {
    	$update = "UPDATE `salaryadvance` SET `employee`='$employee',`amount`='$amount',`bank`='$bank',`extDocNo`='$extDocNo',`date`='$date' WHERE `id`='$id'";
    	$result = mysqli_query($conn, $update);
    	if ($result) {
			$response["status"] = true;
			$response["message"] = "Salary Advance has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Salary Advance could not be updated";
		}
    }
}

else if($type=="staffloan"){
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $monthlyRepayments = $_POST['installments'];
    
    $installments = $amount/$monthlyRepayments;//$_POST['installments'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
	//$monthlyRepayments = $amount/$installments;
    $sel = "SELECT * FROM `staffloan` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select)>0) {
    	$update = "UPDATE `staffloan` SET `employee`='$employee',`amount`='$amount',`bank`='$bank',`extDocNo`='$extDocNo',`date`='$date',`installments`='$installments',`monthlyRepayments`='$monthlyRepayments' WHERE `id`='$id' and posted=0";
    	$result = mysqli_query($conn, $update);
    	if ($result) {
			$response["status"] = true;
			$response["message"] = "Staff loan has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Staff loan could not be updated";
		}
    }
}

else if ($type=="payrollsetups"){
    $id = 0;
    $basicSalary = $_POST['basicSalary'];
    $paye = $_POST['paye'];
    $nhif = $_POST['nhif'];
    $nssf = $_POST['nssf'];
    $salaryAdvance = $_POST['salaryAdvance'];
    $staffLoans = $_POST['staffLoans'];
    $minTaxableAmount = $_POST['minTaxableAmount'];
    $taxRelief = $_POST['taxRelief'];
    $employerKRAPin = $_POST['employerKRAPin'];
    $employerNHIFCode = $_POST['employerNHIFCode'];
    $employerNSSFCode = $_POST['employerNSSFCode'];
    
    $nssfEmployerContribution = $_POST['nssfEmployer'];
    $housingLevy = $_POST['housingLevy'];
    $housingLevyEmployerContribution = $_POST['housingLevyEmployer'];
    $nita = $_POST['nita'];
    $nitaEmployerContribution = $_POST['nitaEmployer'];
    $netPay = $_POST['netPay'];
    


    if (isset($id)) {
        $id = $_POST['id'];
    }
    $sel = mysqli_query($conn, "SELECT * FROM `payrollsetups` WHERE `id`='$id'");
    if (mysqli_num_rows($sel)>0) {
        $update = "UPDATE `payrollsetups` SET `basicSalaryCode`=?,`PAYECode`=?,`NHIFCode`=?,`NSSFCode`=?,`loansCode`=?,`advanceCode`=?,`minTaxableAmount`=?,`tax_relief`=?,`employer_kra_pin`=?,`employer_nhif_code`=?,`employer_nssf_code`=?,`nssf_employer_contribution`=?, `housing_evy`=?, `housing_levy_employer_contribution`=?, `nita`=?, `nita_employer_contribution`=?,`net_pay_account`=? WHERE `id` = ?";
        $values = array($basicSalary,$paye,$nhif,$nssf,$staffLoans,$salaryAdvance,$minTaxableAmount,$taxRelief,$employerKRAPin,$employerNHIFCode,$employerNSSFCode,$nssfEmployerContribution,$housingLevy,$housingLevyEmployerContribution,$nita,$nitaEmployerContribution,$netPay,$id);
        if (pdoExecute($update,$values)) {
            $response["status"] = true;
            $response["message"] = "Payroll Setup has been updated successfully";
        }else{
            $response["status"] = false;
            $response["message"] = "Payroll Setup could not be updated ";
        }
    }else{
        $insert = "INSERT INTO `payrollsetups`(`id`, `basicSalaryCode`, `PAYECode`, `NHIFCode`, `NSSFCode`, `loansCode`, `advanceCode`, `minTaxableAmount`, `tax_relief`, `employer_kra_pin`, `employer_nhif_code`, `employer_nssf_code`,`nssf_employer_contribution`, `housing_evy`, `housing_levy_employer_contribution`, `nita`, `nita_employer_contribution`,`net_pay_account`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        $values = array($id,$basicSalary,$paye,$nhif,$nssf,$staffLoans,$salaryAdvance,$minTaxableAmount,$taxRelief,$employerKRAPin,$employerNHIFCode,$employerNSSFCode,$nssfEmployerContribution,$housingLevy,$housingLevyEmployerContribution,$nita,$nitaEmployerContribution,$netPay);
        if (pdoExecute($insert,$values)) {
            $response["status"] = true;
            $response["message"] = "Payroll Setup has been updated created";
        }else{
            $response["status"] = false;
            $response["message"] = "Payroll Setup could not be created ";
        }
    }

}
else if($type=='salaryadvances'){
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
    $sel = "SELECT * FROM `salaryadvance` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select)>0) {
    	$update = "UPDATE `salaryadvance` SET `employee`='$employee',`amount`='$amount',`bank`='$bank',`extDocNo`='$extDocNo',`date`='$date' WHERE `id`='$id'";
    	$result = mysqli_query($conn, $update);
    	if ($result) {
			$response["status"] = true;
			$response["message"] = "Salary Advance has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Salary Advance could not be updated";
		}
    }
}

else if($type=="staffloan"){
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $monthlyRepayments = $_POST['installments'];
    
    $installments = $amount/$monthlyRepayments;//$_POST['installments'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
	//$monthlyRepayments = $amount/$installments;
    $sel = "SELECT * FROM `staffloan` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select)>0) {
    	$update = "UPDATE `staffloan` SET `employee`='$employee',`amount`='$amount',`bank`='$bank',`extDocNo`='$extDocNo',`date`='$date',`installments`='$installments',`monthlyRepayments`='$monthlyRepayments' WHERE `id`='$id' and posted=0";
    	$result = mysqli_query($conn, $update);
    	if ($result) {
			$response["status"] = true;
			$response["message"] = "Staff loan has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Staff loan could not be updated";
		}
    }
}
else if ($type=="dashboardmatrix"){
    $moduleId = mysqli_real_escape_string($conn,trim($_POST["moduleId"]));
    $roleId = mysqli_real_escape_string($conn,trim($_POST["roleId"]));
    $status = mysqli_real_escape_string($conn,trim($_POST["status"]));
    //get all possible rights for the role, add them to table if not exist
    //assign all of them to view yes
    $check = "SELECT A.*,(SELECT COUNT(id) FROM `dashboardmatrix` WHERE submoduleid =A.id and roleId ='$roleId' )total FROM `submodules` A where A.enabled = 1 and A.moduleId = '$moduleId'";
    $checkRes = mysqli_query($conn,$check);
    $insertSql = "";
    $valuesArray = array();
    while($checkResult = mysqli_fetch_assoc($checkRes)){
        $total =$checkResult["total"] ;
        $subModule = $checkResult["id"];
        if($total==0){
            $insertSql.=strlen($insertSql)==0?",":"";
            $insertSql.="(?,?,?)";
            array_push($valuesArray,$roleId);
            array_push($valuesArray,$subModule);
            array_push($valuesArray,0);
        }
    }
    if(strlen($insertSql)>0){
            $insertSql = "INSERT INTO `dashboardmatrix`(`roleId`, `submoduleid`, `view`) VALUES $insertSql";
            pdoExecute($insertSql,$valuesArray);
    }
    $sql = "update dashboardmatrix set view = ? where roleId=? and submoduleid in (SELECT id FROM `submodules` WHERE moduleId = ?) ";
    $values = array($status,$roleId,$moduleId);
    if(pdoExecute($sql, $values)){
        $response["status"] =true;
        $response["message"] ="The rights were successfully updated";
    }else{
        $response["status"] =false;
        $response["message"] ="The rights could not be updated";
    }
    
}
elseif ($type=="glaccount"){
	if(isset($_POST["accountNumber"])){
	    $accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$accountName = mysqli_real_escape_string($conn, trim($_POST["accountName"]));
		
		$accountType = mysqli_real_escape_string($conn, trim($_POST["accountType"]));
		$accountCategory = mysqli_real_escape_string($conn, trim($_POST["accountCategory"]));
		$accountSubCategory = mysqli_real_escape_string($conn, trim($_POST["accountSubCategory"]));
		$accountGroup = mysqli_real_escape_string($conn, trim($_POST["accountGroup"]));
		$accountCurrency = mysqli_real_escape_string($conn, trim($_POST["accountCurrency"]));
		
		//check exists
		$checkSql = "select * from chartofaccounts where accountNumber = ?";
		$checkValues = array($accountNumber);
		$checkResults = fetchWithPdo($checkSql, $checkValues);
		if(count($checkResults)==0){
		    $response["status"] = false;
    		$response["message"] ="A GL account with the selected account number does not exists";
		}else if(count($checkResults)>1){
		    $response["status"] = false;
    		$response["message"] ="A GL account with the selected account number does not exists";
		}else{
    		$sql = "update `chartofaccounts` set `account_type` = ?, `account_category` =?, `account_sub_category`=?, `account_group`=?,`accountName`=?, `currency` =? where `accountNumber` = ?";
    		$values = array($accountType,$accountCategory,$accountSubCategory,$accountGroup,$accountName,$accountCurrency,$accountNumber);
    			if(pdoExecute($sql,$values)){
    				$response["status"] = true;
    				$response["message"] ="The Account was successfully updated";
    			}else{
    				$response["status"] = false;
    				$response["message"] ="The account could not be updated";
    			}
		}
	}
}
elseif ($type=="customerlocation"){
    $customerNo = trim($_POST["customerNo"]);
    $latitude = trim($_POST["latitude"]);
    $longitude = trim($_POST["longitude"]);
    $placeName = trim($_POST["placeName"]);
    $sql = "UPDATE `customers` SET `location`=?,`location_latitude`=?,`location_longitude`=? WHERE `customerNumber`=?";
    $values = array($placeName,$latitude,$longitude,$customerNo);
     if(pdoExecute($sql, $values)){
        $response["status"] =true;
        $response["message"] ="The customer was successfully updated";
    }else{
        $response["status"] =false;
        $response["message"] ="The customer could not be updated";
    }
    
}
else if($type=="salesline"){
    if(isset($_POST["headerNo"])&&isset($_POST["itemNo"])&&isset($_POST["itemType"])&&isset($_POST["documentType"])&&isset($_POST["lineId"])){
        $headerNo = trim($_POST["headerNo"]);
        $itemType = trim($_POST["itemType"]);
        $itemNo = trim($_POST["itemNo"]);
        $documentType = trim($_POST["documentType"]);
        $lineId = trim($_POST["lineId"]);
        
        
        
        $closingStock = isset($_POST["closingStock"])?trim($_POST["closingStock"]):0;
        $returnToWarehouse = isset($_POST["returnToWarehouse"])?trim($_POST["returnToWarehouse"]):0;
        
        $description = isset($_POST["description"])?trim($_POST["description"]):"";
        $unitOfMeasure = isset($_POST["unitOfMeasure"])?trim($_POST["unitOfMeasure"]):0;
        $details = isset($_POST["details"])?trim($_POST["details"]):"";
        $unitPrice = isset($_POST["unitPrice"])?trim($_POST["unitPrice"]):0;
        $requestedQuantity = isset($_POST["requestedQuantity"])?trim($_POST["requestedQuantity"]):0;
        $issuedQuantity = isset($_POST["issuedQuantity"])?trim($_POST["issuedQuantity"]):0;
        $quantity = isset($_POST["quantity"])?trim($_POST["quantity"]):0;
        $freeIssues = isset($_POST["freeIssues"])?trim($_POST["freeIssues"]):0;
        $missingBottles = isset($_POST["missingBottles"])?trim($_POST["missingBottles"]):0;
        
        $discount = isset($_POST["discount"])?trim($_POST["discount"]):0;
        $kilometres = isset($_POST["kilometres"])?trim($_POST["kilometres"]):0;
        $vehicle = isset($_POST["vehicle"])?trim($_POST["vehicle"]):"";
        
        $taxPercentage = 0;
        $docType = fetchWithPdo("SELECT * FROM `document_types` WHERE code= ?",array($documentType));
        $header = fetchWithPdo("SELECT A.*,B.pricing_group customerPricingGroup,D.pricing_group vsmPricingGroup FROM `sales_header` A LEFT JOIN customers B on A.customer = B.customerNumber LEFT JOIN shopLocations C on A.source_location = C.id LEFT JOIN users D on A.createdBy = D.username WHERE A.doc_no=? ",array($headerNo));
        if(count($header)!=1){ 
            $response["status"] = false;
		    $response["message"] ="The document could not be found";
        }else if(!($header[0]["status"]=="Draft"||$header[0]["status"]=="Pending")){
            $response["status"] = false;
		    $response["message"] ="The document is no longer open for editing";
        }else if(count($docType)<1){
            $response["status"] = false;
		    $response["message"] ="Unknown Document Type";
        }else{
            $getDocument = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ? and document_type = ?",array($headerNo,$documentType));
            if(count($getDocument)<1){
                $response["status"] = false;
		        $response["message"] ="The ".$docType[0]["document_type"]." could not be found";
            }else{
                if($getDocument[0]["posted"]){
                    $response["status"] = false;
		            $response["message"] ="The ".$docType[0]["document_type"]." has alredy been posted";
                }else{
                    $hasError = false;
                    if($itemType=="Services"){
                        $service = fetchWithPdo("SELECT * FROM `chargeitems` WHERE id= ?",array($itemNo));
                        if(count($service)<1){
                            $hasError = true;
                            $response["status"] = false;
		                    $response["message"] ="The service could not be found";
                        }else{
                            $myService = $service[0];
                            $unitPrice = $unitPrice==0?$myService["default_amount"]:$unitPrice;
                            $taxPercentage = $myService["tax_rate"];
                            $description=strlen($description)<1?$myService["description"]:$description;
                        }
                        
                    }else if($itemType=="Items"){
                        $item = fetchWithPdo("SELECT A.code,A.name,A.description, B.percentage taxPercentage,A.unitOfMeasure,A.price,A.buying_price FROM `items` A LEFT JOIN taxGroups B on A.taxGroup = B.code WHERE A.code = ?",array($itemNo));
                        if(count($item)<1){
                            $hasError = true;
                            $response["status"] = false;
		                    $response["message"] ="The product could not be found";
                        }else{
                            $myItem = $item[0];
                            $unitPrice = $unitPrice==0?$myItem["price"]:$unitPrice;
                            if($documentType=="EndofDay"||$documentType=="StockRequest"||$documentType=="WarehouseReturn"){  
                                $unitPrice=getProductPrice($itemNo,$header[0]["vsmPricingGroup"]);
                            }else if($documentType=="storerequisition"){
                                    $unitPrice= $myItem["buying_price"];
                            }
                            else{
                                if($unitPrice==0){
                                    $unitPrice=getProductPrice($itemNo,$header[0]["customerPricingGroup"]);
                                }
                            }
                            $taxPercentage = $myItem["taxPercentage"];
                            $description=strlen($description)<1?$myItem["name"]:$description;
                        }
                    }else{
                        $hasError = true;
                        $response["status"] = false;
		                $response["message"] ="Unknown Item Type";
                    }
                    if(!$hasError){
                        $totalAmount = $unitPrice*$quantity;
                        $totalVAT = ($totalAmount*$taxPercentage)/(100+$taxPercentage);
                        $totalExclVAT = $totalAmount -$totalVAT; 
                        $sql = "update `sales_lines` set  `itemType`=?, `itemNo`=?, `description`=?, `unitOfMeasureCode`=?, `details`=?, `unitPrice`=?,`discount`=?, `requested_quantity`=?, `issued_quantity`=?,`warehouse_return`=?,`free_issues`=?,`closing_stock`=?,`missing_bottles`=?, `quantity`=?, `totalExclVAT`=?, `totalVAT`=?, `totalAmount`=?,`kilometres`=?,`vehicle`=? where `lineId`=? and  `header_no`=? and  `document_type`=? ";
                        $values = array($itemType,$itemNo,$description,$unitOfMeasure,$details,$unitPrice,$discount,$requestedQuantity,$issuedQuantity,$returnToWarehouse,$freeIssues,$closingStock,$missingBottles,$quantity,$totalExclVAT,$totalVAT,$totalAmount,$kilometres,$vehicle,$lineId,$headerNo,$documentType);
                        if(pdoExecute($sql,$values)){
                            $response["status"] = true;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line was successfully updated";
		                    updateInvoiceTotal($headerNo);
                        }else{
                            $response["status"] = false;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line could not be updated";
                        }
                    }
                }
            }
        }
    }else{
        $response["status"] = false;
		$response["message"] ="Some mandatory fields could not be found. Please contact Support";
    }
    
    
}
else if($type=="purchaseline"){
	$headerNo = trim($_POST["headerNo"]);
	$itemType = trim($_POST["itemType"]);
	$documentType = trim($_POST["documentType"]);
	$lineId = trim($_POST["lineId"]);
	$quantity = trim($_POST["quantity"]);
	$itemNo = trim($_POST["itemNo"]);
	$unitPrice = trim($_POST["unitPrice"]);
	//print_r($_POST);
	$getHeader = fetchWithPdo("SELECT * FROM `vendorinvoices` WHERE invoiceNo = (SELECT invoiceNo FROM `vendorinvoicelines` WHERE lineId =? ) ",array($lineId ));
	if(count($getHeader)<1){
			$response["status"] =false;
            $response["message"] ="The document does not exist";
	}
	else if($getHeader[0]["posted"]){
 			$response["status"] =false;
            $response["message"] ="The document has already been posted. No changes can be made";
	}else{
		//echo $itemNo; 
		
		$item = fetchWithPdo("SELECT A.code,A.name,A.description, B.percentage taxPercentage,A.unitOfMeasure,A.price FROM `items` A LEFT JOIN taxGroups B on A.taxGroup = B.code WHERE A.code = ?",array($itemNo));
		if(count($item)==1){
			$description = $item[0]["description"];
			$taxPercentage = $item[0]["taxPercentage"];
			$totalAmount=$unitPrice*$quantity;
        	$totalVAT = ($totalAmount*$taxPercentage)/(100+$taxPercentage);
        	$totalExclVAT = $totalAmount -$totalVAT; 
			$sql = "UPDATE `vendorinvoicelines` SET `itemNo`=?,`description`=?,`unitPrice`=?,`quantity`=?,`totalExclVat`=?,`totalVat`=?,`totalAmount`=? WHERE `lineId`=? and `invoiceNo`=?";
			$values =array($itemNo,$description,$unitPrice,$quantity,$totalExclVAT,$totalVAT,$totalAmount,$lineId,$getHeader[0]["invoiceNo"]);
			if(pdoExecute($sql, $values)){
        	    $response["status"] =true;
        	    $response["message"] ="The record was successfully updated";
        	}else{
        	    $response["status"] =false;
        	    $response["message"] ="The record could not be updated";
        	}
		}else{
			$response["status"] =false;
            $response["message"] ="The product does not exist";
		}
		 
	}
}
else if($type=="sendapprovalentry"){
    $recordType = trim($_POST["recordType"]);
    if($recordType=="salesheader"){
        $docNo = trim($_POST["docNo"]);
        $sql = "update sales_header set status = ? where doc_no=? and status= ?";
        $values = array("Pending",$docNo,"Draft");
         if(pdoExecute($sql, $values)){
            $response["status"] =true;
            $response["message"] ="The record was successfully sent for approval";
        }else{
            $response["status"] =false;
            $response["message"] ="The approval request could not be captured";
        }
        
    }
}
else if($type=="confirmpaymentamount"){
    $lineId = trim($_POST["lineId"]);
    $amount = trim($_POST["amount"]);
    $field = "";
    if(isset($_POST["field"])){
        $field = trim($_POST["field"]);
    }
    if($field=="quantity"){
        $quantity = $amount;
        //get non free version
        //get vsms pricing group
        //get price
        
        $getEntry = fetchWithPdo("SELECT A.product_code,B.createdBy,C.pricing_group FROM `daily_report_payments` A LEFT JOIN sales_header B on A.report_id = B.doc_no LEFT JOIN users C on B.createdBy =C.username WHERE id= ?",array($lineId));
        if(count($getEntry)>0){
            
            $productCode = getNonFreeVersionCode($getEntry[0]["product_code"]);
            $price = getProductPrice($productCode,$getEntry[0]["pricing_group"]);
            $amount=$price*$quantity;
            $sql = "UPDATE `daily_report_payments` SET `quantity`=?,`confirmed_amount`=? where `id`=? limit 1";
            $values = array($quantity,$amount,$lineId);
            if(pdoExecute($sql, $values)){
                    $response["status"] =true;
                    $response["message"] ="The record was successfully updated";
            }else{
                    $response["status"] =false;
                    $response["message"] ="The  record could not be updated";
            }
        }else{
            $response["status"] =false;
            $response["message"] ="The  record could not be found";
        }
        
    }else if($field=="discount"){
        $sql = "UPDATE `daily_report_payments` SET `discount`=? where `id`=? limit 1";
        $values = array($amount,$lineId);
        if(pdoExecute($sql, $values)){
                $response["status"] =true;
                $response["message"] ="The record was successfully updated";
        }else{
                $response["status"] =false;
                $response["message"] ="The  record could not be updated";
        }
    }else{
        $sql = "UPDATE `daily_report_payments` SET `confirmed_amount`=? where `id`=? limit 1";
        $values = array($amount,$lineId);
        if(pdoExecute($sql, $values)){
                $response["status"] =true;
                $response["message"] ="The record was successfully updated";
        }else{
                $response["status"] =false;
                $response["message"] ="The  record could not be updated";
        }
    }
}
else if($type=="salespayments"){
    $headerNo = trim($_POST["headerNo"]);
    $paymentMethodId = trim($_POST["paymentMethodId"]);
    $amount = isset($_POST["amount"])?trim($_POST["amount"]):0;
    
    
      
    if(isset($_POST["customer"])){
        $customer = trim($_POST["customer"]);
        $invoiceNo = trim($_POST["invoiceNo"]);
        $insert = pdoExecute("INSERT INTO `daily_report_payments`(`report_id`, `payment_method`,`customer_code`,`invoice_no`, `amount`,`confirmed_amount`) VALUES (?,?,?,?,?,?)",array($headerNo,$paymentMethodId,$customer,$invoiceNo,$amount,$amount));
        if($insert){
            $response["status"] = true;
		    $response["message"] ="The payment was successfully added";
        }else{
            $response["status"] = false;
		    $response["message"] ="The payment could not be added";
        }
        
    }else if(isset($_POST["customerName"])){
        $customerName = trim($_POST["customerName"]);
        $product = trim($_POST["product"]);
        $quantity = trim($_POST["quantity"]); 
        //get foregone amount
        $originalProductCode = getNonFreeVersionCode($product);//getFreeVersionCode($product);
        $originalProduct = fetchWithPdo("SELECT price FROM `items` WHERE code = ?",array($originalProductCode));
        if(count($originalProduct)==1){
            $amount = $originalProduct[0]["price"]*$quantity;
            $sql = "INSERT INTO `daily_report_payments`(`report_id`, `payment_method`,  `customer_name`, `amount`, `confirmed_amount`,`product_code`, `quantity`) VALUES (?,?,?,?,?,?,?)";
            $values = array($headerNo,$paymentMethodId,$customerName,$amount,$amount,$product,$quantity);
            if(pdoExecute($sql,$values)){
                $response["status"] = true;
		        $response["message"] ="The payment was successfully added";
            }else{
                $response["status"] = false;
		        $response["message"] ="The payment could not be added";
            }
            
        }else{
            $response["status"] = false;
		    $response["message"] ="The non free version($originalProductCode) of the product does not exit";
        }
         
        
        
    }
    else if(isset($_POST["discountCustomer"])){
        $customer = trim($_POST["discountCustomer"]);
        $product = trim($_POST["product"]);
        $quantity = trim($_POST["quantity"]); 
        
        $vsm = fetchWithPdo("SELECT * FROM users WHERE username = (SELECT createdBy from sales_header WHERE sales_header.doc_no = ?)",array($headerNo));
        $vsmPricingGroup = $vsm[0]["pricing_group"];
        $myCustomer = fetchWithPdo("SELECT * from customers WHERE customerNumber = ?",array($customer));
        $customerPricingGroup = $myCustomer[0]["pricing_group"];
        $normalPrice = getProductPrice($product,$vsmPricingGroup);
        $discountedPrice = getProductPrice($product,$customerPricingGroup);
        
        $sellingPrice = $discountedPrice*$quantity;
        $discount = ($normalPrice*$quantity)-$sellingPrice;
        
        //
        //get normal price
        //get special cutomer price
        //add discount
        
        //
        
        $sql = "INSERT INTO `daily_report_payments`(`report_id`, `payment_method`, `customer_code`, `amount`,`confirmed_amount`, `product_code`, `quantity`, `discount`) VALUES (?,?,?,?,?,?,?,?)";
        $values = array($headerNo,$paymentMethodId,$customer,$sellingPrice,$sellingPrice,$product,$quantity,$discount);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
		       $response["message"] ="The payment was successfully added";
        }else{
            $response["status"] = false;
		       $response["message"] ="The payment could not be added";
        }
            
       
         
        
        
    }
    else{
    $check = fetchWithPdo("SELECT * FROM `daily_report_payments` WHERE `report_id`=? and `payment_method`= ?",array($headerNo,$paymentMethodId));
    if(count($check)==0){
        $insert = pdoExecute("INSERT INTO `daily_report_payments`(`report_id`, `payment_method`, `amount`,`confirmed_amount`) VALUES (?,?,?,?)",array($headerNo,$paymentMethodId,$amount,$amount));
        if($insert){
            $response["status"] = true;
		    $response["message"] ="The payment was successfully added";
        }else{
            $response["status"] = false;
		    $response["message"] ="The payment could not be added";
        }
        
    }else if(count($check)==1){
        $updated = pdoExecute("update `daily_report_payments`  set `amount`=?,`confirmed_amount`=? where `report_id`=? and  `payment_method`=? ",array($amount,$amount,$headerNo,$paymentMethodId));
        if($updated){
            $response["status"] = true;
		    $response["message"] ="The payment was successfully updated";
        }else{
            $response["status"] = false;
		    $response["message"] ="The payment could not be updated";
        }
    }
    }
}
else if($type=="useraccount"){
    $fullName=trim($_POST["fullName"]);
    $emailAddress=trim($_POST["emailAddress"]);
    $phoneNumber=trim($_POST["phoneNumber"]);
    $password=trim($_POST["password"]);
    $sql = "UPDATE `users` SET `fullname`=?,`email`=?,`phone`=? where `username`=?";
    $values =array($fullName,$emailAddress,$phoneNumber,$myUserName);
    if(strlen($password)>0){
        $password = hash("sha256",$password);
        $sql = "UPDATE `users` SET `fullname`=?,`email`=?,`phone`=?,`Password`=? where `username`=?";
        $values =array($fullName,$emailAddress,$phoneNumber,$password,$myUserName);
    }
    if(pdoExecute($sql, $values)){
            $response["status"] =true;
            $response["message"] ="Your account was successfully updated";
    }else{
            $response["status"] =false;
            $response["message"] ="Your  account could not be updated";
    }

}


else if($type=="send_approval"){
    $docNo = trim($_POST["docNo"]);
    $docType = trim($_POST["docType"]);
   $sql = "UPDATE `sales_header` SET `status`=? WHERE `doc_no`=? and `document_type`=? limit 1";
   $values = array("Pending",$docNo,$docType);
   if(pdoExecute($sql,$values)){
            $response["status"] = true;
		    $response["message"] ="The document was successfully sent for approval";
    }else{
            $response["status"] = false;
		    $response["message"] ="The document could not be sent for approval";
   }
}
else if($type=="reject_document"){
    $docNo = trim($_POST["docNo"]);
    $docType = trim($_POST["docType"]);
   $sql = "UPDATE `sales_header` SET `status`=? WHERE `doc_no`=? and `document_type`=? limit 1";
   $values = array("Draft",$docNo,$docType);
   if(pdoExecute($sql,$values)){
            $response["status"] = true;
		    $response["message"] ="The document was successfully rejected";
    }else{
            $response["status"] = false;
		    $response["message"] ="The document could not be rejected";
   }
}
else if($type=="expresssaleline"){
	$lineId = trim($_POST["lineId"]);
	$getItem = "SELECT A.*,B.posted,C.price,D.percentage FROM `expresssalelines` A LEFT JOIN expressSales B on A.saleCode = B.code LEFT JOIN items C on A.item = C.code LEFT JOIN taxGroups D on C.taxGroup =D.code WHERE A.id= ?";
	$res = fetchWithPdo($getItem,array($lineId));
	if(!(count($res)==1)){
		$response["status"] = false;
		$response["message"] ="The sales line does not exist";
	}else{
		$posted = $res[0]["posted"];
		if($posted){
			$response["status"] = false;
			$response["message"] ="The receipt has already been posted";
		}else{
            
	
			$update ="UPDATE `expresssalelines` SET `unitPrice`=?,`quantity`=?,`totalExclVAT`=?,`totalVAT`=?,`totalAmount`=? WHERE `id`=? ";
			$unitPrice = isset($_POST["unitPrice"])?$_POST["unitPrice"]:$res[0]["unitPrice"];
			$quantity = isset($_POST["quantity"])?$_POST["quantity"]:$res[0]["quantity"];
			$percentage = $res[0]["percentage"];///100;
			$totalAmount = $unitPrice*$quantity;
			$totalVAT = round((($totalAmount/(100+$percentage))*$percentage),2);
			$totalExcl = $totalAmount-$totalVAT;
			
			$values = array($unitPrice,$quantity,$totalExcl,$totalVAT,$totalAmount,$lineId);
			if(pdoExecute($update,$values)){
				$response["status"] = true;
				$response["message"] ="The line was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] ="The line could not be updated";
			}
		}

		
	}
}
else if($type=="transfer_all"){
    $transferNo = trim($_POST["transferNo"]);
    $transfers = fetchWithPdo("SELECT * FROM `stocktransfers` WHERE code = ?",array($transferNo));
    if(count($transfers)==1){
        $transfer = $transfers[0];
        if($transfer["posted"]){
            $response["status"] = false;
		    $response["message"] ="The stock transfer has already been poted";
        }else if($transfer["transferFrom"]<2){
            $response["status"] = false;
		    $response["message"] ="Invalid source warehouse";
        }
        else{
            $lineSql = "";
            $lineValues = array();
            $allStock = fetchWithPdo("SELECT itemNo,SUM(quantity) totalAvailable FROM `itemledgerentries` WHERE location = ? and NOT itemNo =? GROUP by itemNo",array($transfer["transferFrom"],getEmptiesCode()));
            foreach($allStock as $stock){
                $availableQuantity = $stock["totalAvailable"];
                if($availableQuantity>0){
                    $lineSql.=strlen($lineSql)>0?",":"";
                    $lineSql.="(?,?,?,?)";
                    $lineValues = array_merge($lineValues,array($stock["itemNo"],0,$availableQuantity,$transferNo));
                }
            }
            if(strlen($lineSql)<1){
                $response["status"] = false;
		        $response["message"] ="We didn't find any stock";
            }else{
                $lineSql = "INSERT INTO `stocktransferlines`(`item`, `unitPrice`, `quantity`, `transferCode`) VALUES $lineSql";
                if(pdoExecute($lineSql,$lineValues)){
                    $response["status"] = true;
                	$response["message"] ="The lines were successfully added";
                  }else{
                    $response["status"] = false;
                	$response["message"] ="The lines could not be added";
                 }
            }
            
            
        }
    }else{
        $response["status"] = false;
		$response["message"] ="We could not find the stock transfer";
    }
    //make sure not posted
    //make sure source is set
}
else if($type=="credit_note_lines"){
    $creditNoteNo = trim($_POST["creditNoteNo"]);
    $invoiceDetails = explode("-",trim($_POST["invoiceNo"]));
    
    $invoiceNo =trim($invoiceDetails[0]);
    
    $documentType = trim($_POST["documentType"]);
     //check if has line
     //copy lines
     $lines = fetchWithPdo("SELECT * FROM `sales_lines` WHERE header_no=?",array($creditNoteNo));
     if(count($lines)>0){
         $response["status"] = false;
		 $response["message"] ="Lines have already been added on the invoice";
     }else{
         $originalLines = fetchWithPdo("SELECT * FROM `sales_lines` WHERE header_no=?",array($invoiceNo));
         if(count($originalLines)>0){
             $sql = "";
             $lineValues = array();
             foreach($originalLines as $line){
                 $sql.=strlen($sql)>0?",":"";
                 $sql.="(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
                 $lineValues = array_merge($lineValues,array($creditNoteNo,$documentType,$line["itemType"],$line["itemNo"],$line["description"],$line["unitOfMeasureCode"],$line["details"],$line["unitPrice"],$line["discount"],$line["requested_quantity"],$line["issued_quantity"],$line["opening_stock"],$line["issued_stock"],$line["warehouse_return"],$line["free_issues"],$line["closing_stock"],$line["missing_bottles"],$line["quantity"],$line["totalExclVAT"],$line["totalVAT"],$line["totalAmount"],$line["kilometres"],$line["vehicle"],$myUserName));
             }
             $sql = "INSERT INTO `sales_lines`( `header_no`, `document_type`, `itemType`, `itemNo`, `description`, `unitOfMeasureCode`, `details`, `unitPrice`, `discount`, `requested_quantity`, 
             `issued_quantity`, `opening_stock`, `issued_stock`, `warehouse_return`, `free_issues`, `closing_stock`, `missing_bottles`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`,
             `kilometres`, `vehicle`, `created_by`, `createdOn`) VALUES $sql";
             if(pdoExecute($sql,$lineValues)){
                 updateInvoiceTotal($creditNoteNo);
				$response["status"] = true;
				$response["message"] ="The lines were successfully added";
			}else{
				$response["status"] = false;
				$response["message"] ="The lines could not be added";
			}
         }else{
             $response["status"] = false;
		     $response["message"] ="No lines found for the original invoice no $invoiceNo. Please try again";
         }
     }
}


echo json_encode($response);