<?php
include_once("functions.php");
if(isset($_GET["mode"])){
    //$purchases = getPurchases();
   // print_r($purchases);

   //P600000702A
   //5CG4521NZM
}else{
    
}
//initialize();
//codeRequest();
//getItemClasses();
//getBranches();
//getItems();
//fetchImportedItems();
//getPurchases();
//getStock();
//getNotices();
//stockMoveRequest();
//saveBranchUser("00","mwangi","mwangi","mwangi1");
//saveBranchCustomer("00","CUST001","P052108449D","Kuza Systems and Solution Ltd");
//saveBranchInsurance("00","ISRCC01","RSSB Insurance",20);
//lookUpCustomer("00","A987654321Z");
//updateStock("00","KE1NTXU0000009",1);

function initialize($branchId,$serialNo){
    $postData = getDefaultPostBody($branchId,$serialNo);
    //print_r($postData);
    $response = sendToEtims("initializer/selectInitInfo",$postData);
    return  $response;
   // print_r($response);
}
function codeRequest($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("code/selectCodes",$postData);
    //print_r($response);
    foreach($response["data"]["clsList"] as $entry){
      //  print_r($entry);
        $cdCls = $entry["cdCls"];
        if($cdCls=="04"){//tax categories
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"],$listItem["userDfnCd1"]));
            }
            pdoExecute("DELETE from taxGroups",array());
            $lines="INSERT INTO `taxGroups`(`code`, `name`, `percentage`) VALUES  $lines";
            pdoExecute($lines,$lineValues);
        }
        else if($cdCls=="05"){//countries
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"]));
            }
            pdoExecute("DELETE from countries",array());
            $lines="INSERT INTO `countries`(`code`, `country_name`) VALUES $lines";
            pdoExecute($lines,$lineValues);
        }else if($cdCls=="07"){//payment methods
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"]));
            }
            pdoExecute("DELETE from etims_payment_methods",array());
            $lines="INSERT INTO `etims_payment_methods`(`code`, `name`) VALUES $lines";
            pdoExecute($lines,$lineValues);
        }else if($cdCls=="10"){//Quantity Units
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"],"Quantity"));
            }
             pdoExecute("DELETE from unitsOfMeasure",array());
            $lines="INSERT INTO `unitsOfMeasure`(`code`, `name`, `type`) VALUES $lines";
           // echo $lines;
            //print_r($lineValues);
            pdoExecute($lines,$lineValues);
        }else if($cdCls=="17"){//Packaging Units
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"],"Packaging"));
            }
            $lines="INSERT INTO `unitsOfMeasure`(`code`, `name`, `type`) VALUES $lines";
            pdoExecute($lines,$lineValues);
        }else if($cdCls=="24"){//Packaging Units
            $lines = "";
            $lineValues = array();
            foreach($entry["dtlList"] as $listItem){
               $lines.= strlen($lines)?",":"";
               $lines.= "(?,?)";
               $lineValues = array_merge($lineValues,array($listItem["cd"],$listItem["cdNm"]));
            }
            pdoExecute("DELETE from item_type",array());
            $lines="INSERT INTO `item_type`(`code`, `name`) VALUES $lines";
            pdoExecute($lines,$lineValues);
        }
    }
    return $response["data"]["clsList"];
}
function getItemClasses($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("itemClass/selectItemsClass",$postData);
    $lines = "";
    $lineValues = array();
    foreach($response["data"]["itemClsList"] as $listItem){
        $lines.= strlen($lines)?",":"";
        $lines.= "(?,?)";
        $lineValues = array_merge($lineValues,array($listItem["itemClsCd"],$listItem["itemClsNm"]));   
    }
    pdoExecute("delete from etims_item_classes",array());
    $lines="INSERT INTO `etims_item_classes`(`code`, `name`) VALUES $lines";
    pdoExecute($lines,$lineValues);
    return $response["data"]["itemClsList"];
}

function getBranches($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("branches/selectBranches",$postData);
    $branches = $response["data"]["bhfList"];
    foreach($branches as $branch){
        $check =fetchWithPdo("SELECT * FROM `shopLocations` WHERE `etims_branch_code`=?",array($branch["bhfId"]));
        if(count($check)<1){
            $sql = "INSERT INTO `shopLocations`(`name`, `vsm`, `added_on`, `added_by`, `etims_branch_code`) VALUES (?,?,NOW(),'',?)";
            $values = array($branch["bhfNm"],0,$branch["bhfId"]);
            pdoExecute($sql,$values);
        }
    }
    return $response["data"]["bhfList"];
}
function getItems($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("items/selectItems",$postData);
    return $response["data"]["itemList"];
}
function fetchImportedItems($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("imports/selectImportItems",$postData);
    if(isset($response["data"]["itemList"])){
        return $response["data"]["itemList"];
    }else{
        return array();
    }
   
}
function getPurchases($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("trnsPurchase/selectTrnsPurchaseSales",$postData);
 //return $response;
    if(isset($response["data"]["saleList"])){
        $allEntries = array();
        foreach($response["data"]["saleList"] as $line){
            $myLine = array();
            $myLine["spplrTin"]="hello";
            array_push($allEntries,$myLine);
            createPurchaseInvoice($line);
            //echo "My Entry is here";
            //Array(    [0] => Array        (            [itemSeq] => 1            [itemCd] => AL1BLXDRX0000001            [itemClsCd] => 57030300            [itemNm] => AMERICA            [bcd] =>             [pkgUnitCd] => BL            [pkg] => 0            [qtyUnitCd] => DR            [qty] => 5            [prc] => 500            [splyAmt] => 2500            [dcRt] => 0            [dcAmt] => 0            [taxTyCd] => B            [taxblAmt] => 2500            [taxAmt] => 344.83            [totAmt] => 2500     
        }
        return $response["data"]["saleList"];
    }else{
        return array();
    }
}
function getStock($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("stock/selectStockItems",$postData);
    return $response;
}
function getNotices($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("notices/selectNotices",$postData);
    return $response["data"]["noticeList"];
}
function stockMoveRequest($branchId){
    $postData = getDefaultPostBodyWithDate($branchId);
    $response = sendToEtims("stock/selectStockItems",$postData);
    return $response;
}
function saveBranchUser($branchId,$userId,$userName,$password,$address,$cntc,$authCd,$remark,$useYn,$regrNm,$regrId,$modrNm,$modrId){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'userId' => $userId,
                'userNm' => $userName,
                'pwd' => $password,
                'adrs' => $address,
                'cntc' => $cntc,
                'authCd' => $authCd,
                'remark' => $remark,
                'useYn' => $useYn,
                'regrNm' => $regrNm,
                'regrId' => $regrId,
                'modrNm' => $modrNm,
                'modrId' => $modrId
            ];
    $response = sendToEtims("branches/saveBrancheUsers",$postData);
    return $response;
}
function saveBranchCustomer($branchId,$customerNo,$customerPin,$customerName){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'custNo' => $customerNo,
                'custTin' => $customerPin,
                'custNm' => $customerName,
                'adrs' => null,
                'telNo' => null,
                'email' => null,
                'faxNo' => null,
                'useYn' => 'Y',
                'remark' => null,
                'regrNm' => 'Admin',
                'regrId' => 'Admin',
                'modrNm' => 'Admin',
                'modrId' => 'Admin'
            ];
            
    //$response = sendToEtims("branches/saveBrancheCustomers",$postData);
     $response = stageRequest("branches/saveBrancheCustomers",$postData);
    return $response;
}
function saveBranchInsurance($branchId,$isrccCd,$isrccNm,$isrcRt,$useYn,$regrNm,$regrId,$modrNm,$modrId){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'isrccCd' => $isrccCd,
                'isrccNm' => $isrccNm,
                'isrcRt' => $isrcRt,
                'useYn' => $useYn,
                'regrNm' => $regrNm,
                'regrId' => $regrId,
                'modrNm' => $modrNm,
                'modrId' => $modrId
            ];
    $response = sendToEtims("branches/saveBrancheInsurances",$postData);
    return $response;
}
function addItemComposition($branchId,$itemCd,$cpstItemCd,$cpstQty,$regrNm,$regrId){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'itemCd' => $itemCd,
                'cpstItemCd' => $cpstItemCd,
                'cpstQty' => $cpstQty,
                'regrNm' => $regrNm,
                'regrId' => $regrId
            ];
    $response = sendToEtims("items/saveItemComposition",$postData);
    return $response;
}
function updateImportedItem($branchId,$taskCd,$dclDe,$itemSeq,$hsCd,$itemClsCd,$itemCd,$imptItemSttsCd,$remark,$modrNm,$modrId){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'taskCd' => $taskCd,
                'dclDe' => $dclDe,
                'itemSeq' => $itemSeq,
                'hsCd' => $hsCd,
                'itemClsCd' => $itemClsCd,
                'itemCd' => $itemCd,
                'imptItemSttsCd' => $imptItemSttsCd,
                'remark' => $remark,
                'modrNm' => $modrNm,
                'modrId' => $modrId
            ];
        // echo json_encode($postData)
    $response = sendToEtims("imports/updateImportItems",$postData);


    return $response;
}

function lookUpCustomer($branchId,$customerPin){
    
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'custmTin' => $customerPin
            ];
    $response = sendToEtims("customers/selectCustomer",$postData);
    return $response;
}
function updateStock($branchId,$itemCode,$availableQuantity){
    $response = array();
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'itemCd' => $itemCode,
                'rsdQty' => $availableQuantity,
                'regrId' => 'Admin',
                'regrNm' => 'Admin',
                'modrNm' => 'Admin',
                'modrId' => 'Admin'
            ];
    
    stageRequest("stockMaster/saveStockMaster",$postData);
    return $response;
    //$response = sendToEtims("stockMaster/saveStockMaster",$postData);
    //return $response["resultMsg"];
}

function createItem($branchId,$itemCode,$itemClsCd,$itemTyCd,$itemNm,$itemStdNm,$orgnNatCd,$pkgUnitCd,$qtyUnitCd,$taxTyCd,$btchNo,$bcd,$dftPrc
        ,$grpPrcL1,$grpPrcL2,$grpPrcL3,$grpPrcL4,$grpPrcL5,$addInfo,$sftyQty,$isrcAplcbYn,$useYn){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'itemCd' => $itemCode,
                'itemClsCd' => $itemClsCd,
                'itemTyCd' => $itemTyCd,
                'itemNm' => $itemNm,
                'itemStdNm' => $itemStdNm,
                'orgnNatCd' => $orgnNatCd,
                'pkgUnitCd' => $pkgUnitCd,
                'qtyUnitCd' => $qtyUnitCd,
                'taxTyCd' => $taxTyCd,
                'btchNo' => $btchNo,
                'bcd' => $bcd,
                'dftPrc' => $dftPrc,
                'grpPrcL1' => $grpPrcL1,
                'grpPrcL2' => $grpPrcL2,
                'grpPrcL3' => $grpPrcL3,
                'grpPrcL4' => $grpPrcL4,
                'grpPrcL5' => $grpPrcL5,
                'addInfo' => $addInfo,
                'sftyQty' => $sftyQty,
                'isrcAplcbYn' => $isrcAplcbYn,
                'useYn' => $useYn,
                'regrNm' => 'Admin',
                'regrId' => 'Admin',
                'modrNm' => 'Admin',
                'modrId' => 'Admin'
            ];
            
    //$response = sendToEtims("items/saveItems",$postData);
    $response = stageRequest("items/saveItems",$postData);
    return $response;
}
function createSale($branchId,$trdInvcNo,$invcNo,$orgInvcNo,$custTin,$custNm,$salesTyCd,$rcptTyCd,$pmtTyCd,$salesSttsCd,$cfmDt,$salesDt,$stockRlsDt,$cnclReqDt,$lines){
    $taxblAmtA = 0;
    $taxRtA = 0;
    $taxAmtA = 0;
    $taxblAmtB = 0;
    $taxRtB = 16;
    $taxAmtB = 0;
    $taxblAmtC = 0;
    $taxRtC = 0;
    $taxAmtC = 0;
    $taxblAmtD = 0;
    $taxRtD = 0;
    $taxAmtD = 0;
    $taxblAmtE = 0;
    $taxRtE = 8;
    $taxAmtE = 0;
    $itemList = array();
    $sequence = 1;
    $totTaxblAmt =0;
    $totTaxAmt =0;
    $totAmt  =0;
    $totalDiscount = 0;
    foreach($lines as $line){
    if($line["taxGroup"]=="A"){
        $taxblAmtA +=kuzaRound($line["totalAmount"],2);
        $taxAmtA +=  kuzaRound($line["totalVAT"],2);
    }else if($line["taxGroup"]=="B"){
        $taxblAmtB +=kuzaRound($line["totalAmount"],2);
        $taxAmtB +=kuzaRound($line["totalVAT"],2);
    }else if($line["taxGroup"]=="C"){
        $taxblAmtC +=kuzaRound($line["totalAmount"],2);
        $taxAmtC +=kuzaRound($line["totalVAT"],2);
    }else if($line["taxGroup"]=="D"){
        $taxblAmtD +=kuzaRound($line["totalAmount"],2);
        $taxAmtD +=kuzaRound($line["totalVAT"],2);
    }else if($line["taxGroup"]=="E"){
        $taxblAmtE +=kuzaRound($line["totalAmount"],2);
        $taxAmtE +=kuzaRound($line["totalVAT"],2);
    }
    $totTaxblAmt += kuzaRound($line["totalAmount"],2);
    $totTaxAmt += kuzaRound($line["totalVAT"],2);
    $totAmt  += kuzaRound($line["totalAmount"],2);
    $totalDiscount  += kuzaRound($line["discount"],2);

        $listEntry =  [
                'itemSeq' => $sequence,
                'itemCd' => $line["code"],
                'itemClsCd' => $line["item_class"],
                'itemNm' => $line["name"],
                'bcd' => null,
                'pkgUnitCd' => $line["packaging_unit"],
                'pkg' => 1,
                'qtyUnitCd' => $line["unitOfMeasure"],
                'qty' => $line["quantity"],
                'prc' => $line["unitPrice"],
                'splyAmt' =>$line["totalAmount"],# $line["unitPrice"],
                'dcRt' => kuzaRound($line["discount"]/$line["unitPrice"],2),
                'dcAmt' => kuzaRound($line["discount"],2),
                'isrccCd' => null,
                'isrccNm' => null,
                'isrcRt' => null,
                'isrcAmt' => null,
                'taxTyCd' => $line["taxGroup"],
                'taxblAmt' => kuzaRound(($line["totalAmount"]-$line["totalVAT"]),2),
                'taxAmt' => kuzaRound($line["totalVAT"],2),
                'totAmt' => kuzaRound($line["totalAmount"],2)
                
                
            ];
        array_push($itemList,$listEntry);
        $sequence++;
    }
    
    $taxAmtB = kuzaRound($taxAmtB,2);
    $taxAmtB  = str_ireplace(",","",$taxAmtB);
    $receipt= [
                'custTin' => $custTin,
                'custMblNo' => null,
                'rptNo' => '1',
                'trdeNm' => '',
                'adrs' => '',
                'topMsg' => 'Thanks for shopping with us',
                'btmMsg' => 'Thanks for shopping with us',
                'prchrAcptcYn' => 'N',
            ];
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'trdInvcNo' => $trdInvcNo,
                'invcNo' => $invcNo,
                'orgInvcNo' => $orgInvcNo,
                'custTin' => $custTin,
                'custNm' => $custNm,
                'salesTyCd' => $salesTyCd,
                'rcptTyCd' => $rcptTyCd,
                'pmtTyCd' => $pmtTyCd,
                'salesSttsCd' => $salesSttsCd,
                'cfmDt' => $cfmDt,
                'salesDt' => $salesDt,
                'stockRlsDt' => $stockRlsDt,
                'cnclReqDt' => $cnclReqDt,
                'cnclDt' => null,
                'rfdDt' => null,
                'rfdRsnCd' => null,
                'totItemCnt' => count($lines),
                'taxblAmtA'=>kuzaRound($taxblAmtA,2), 
                'taxblAmtB'=>kuzaRound($taxblAmtB,2), 
                'taxblAmtC'=>kuzaRound($taxblAmtC,2), 
                'taxblAmtD'=>kuzaRound($taxblAmtD,2), 
                'taxblAmtE'=>kuzaRound($taxblAmtE,2), 
                'taxRtA'=>   kuzaRound($taxRtA,2), 
                'taxRtB'=>   kuzaRound($taxRtB,2), 
                'taxRtC'=>   kuzaRound($taxRtC,2), 
                'taxRtD'=>   kuzaRound($taxRtD,2), 
                'taxRtE'=>   kuzaRound($taxRtE,2), 
                'taxAmtA'=>  kuzaRound($taxAmtA,2), 
                'taxAmtB'=>  kuzaRound($taxAmtB,2), 
                'taxAmtC'=>  kuzaRound($taxAmtC,2), 
                'taxAmtD'=>  kuzaRound($taxAmtD,2), 
                'taxAmtE'=>  kuzaRound($taxAmtE,2), 
                'totTaxblAmt'=>kuzaRound(($totTaxblAmt-$totTaxAmt),2), 
                'totTaxAmt'=>kuzaRound($totTaxAmt,2), 
                'totAmt'=>kuzaRound($totAmt,2) , 
                'prchrAcptcYn'=>'N' , 
                'remark'=>null , 
                'regrId'=> 'Admin',
                'regrNm'=>'Admin',
                'modrId'=>'Admin',
                'modrNm'=>'Admin',
                'receipt' => $receipt,
                'itemList' => $itemList
            ];
         echo json_encode($postData);
    $response = sendToEtims("trnsSales/saveSales",$postData);
    echo json_encode($response)."  Is the Etims Response";
    $qrCode ="";
    echo "Niko hapa 69";
    if(isset($response["data"])){
    echo "Niko hapa 70";
        if(isset($response["data"]["rcptSign"])){
            echo "Niko hapa 71";
            $signature = $response["data"]["rcptSign"];
            //$qrCode="https://etims-sbx.kra.go.ke/common/link/etims/receipt/indexEtimsReceiptData?Data=".getKRAPIN().$branchId.$signature;
            $qrCode="https://etims.kra.go.ke/common/link/etims/receipt/indexEtimsReceiptData?Data=".getKRAPIN().$branchId.$signature;
           // echo $qrCode;
            //$qrCode="https://etims.kra.go.ke/common/link/etims/receipt/indexEtimsReceptData?".getKRAPIN().$branchId.$signature;
            //$qrCode="https://etims-sbx.kra.go.ke/common/link/etims/receipt/indexEtimsReceiptData?Data=P600000427A00PODQPEOILY7N3IX2".getKRAPIN().$branchId.$signature;
            //$qrCode="https://etims-sbx.kra.go.ke/common/link/etims/receipt/indexEtimsReceiptData?Data=".getKRAPIN().$branchId.$signature;
        } 
    }
    $response["qrCode"]=$qrCode;
    $response["invcNo"]=$invcNo;
    //print_r($response);
    return $response;

}
function createAPurchase($branchId, $etimsInvoiceNo,$salesHeader,$purchaseLines,$rcptTyCd){
    $taxRtA =0;
    $taxRtB =016;
    $taxRtC =0;
    $taxRtD =0;
    $taxRtE =8;
    $taxblAmtA=0;
    $taxblAmtB=0;
    $taxblAmtC =0;
    $taxblAmtD =0;
    $taxblAmtE =0;
    $taxAmtA =0;
    $taxAmtB =0;
    $taxAmtC =0;
    $taxAmtD =0;
    $taxAmtE =0;
    $totTaxblAmt =0;
    $totTaxAmt =0;
    $totAmt =0;
    $itemList = array();
    $sequence=1;
    foreach($purchaseLines as $line){
        $taxGroup = $line["taxGroup"];
        $lineTotal = kuzaRound($line["totalAmount"],2);
        $lineVat = kuzaRound($line["totalVAT"],2);
        $totTaxblAmt+=$lineTotal;
        $totAmt+=$lineTotal;
        $totTaxAmt+=$lineVat;
        if($taxGroup=="A"){
            $taxblAmtA+=$lineTotal;
            $taxAmtA +=$lineVat;
        }else if($taxGroup=="B"){
            $taxblAmtB+=$lineTotal;
            $taxAmtB +=$lineVat;
        }else if($taxGroup=="C"){
            $taxblAmtC +=$lineTotal;
            $taxAmtC +=$lineVat;
        }else if($taxGroup=="D"){
            $taxblAmtD +=$lineTotal;
            $taxAmtD +=$lineVat;
        }else if($taxGroup=="E"){
            $taxblAmtE +=$lineTotal;
            $taxAmtE +=$lineVat;
        }
    $listEntry =  [
            "itemSeq"=> $sequence,
            "itemCd" =>  $line["itemNo"],
            "itemClsCd"=>  $line["item_class"],
            "itemNm"=>  $line["description"],
            "bcd"=>  $line["upcCode"],
            "spplrItemClsCd"=>  null,
            "spplrItemCd"=>  null,
            "spplrItemNm"=>  null, 
            "pkgUnitCd"=>  $line["packaging_unit"],
            "pkg"=>  $line["quantity"],
            "qtyUnitCd"=>  $line["unitOfMeasure"], 
            "qty"=>  $line["quantity"], 
            "prc"=>  kuzaRound($line["unitPrice"],2),
            "splyAmt"=>  kuzaRound($lineTotal,2),
            "dcRt"=>  0,
            "dcAmt"=>  0,
            "taxblAmt"=>  kuzaRound($lineTotal,2),
            "taxTyCd"=>  $line["taxGroup"], 
            "taxAmt"=>  kuzaRound($lineVat,2),
            "totAmt"=>  kuzaRound($lineTotal,2),
            "itemExprDt"=>  null
            ];
        array_push($itemList,$listEntry);
        $sequence++;
    }
    $date = new DateTime($salesHeader["invoiceDate"]);
    $cfmDt = $date->format('YmdHis');
    $pchsDt = $date->format('Ymd');
     $postData= [
                "tin" => getKRAPIN(),
                "bhfId" => $branchId,
                "invcNo" => $etimsInvoiceNo,
                "orgInvcNo" => $etimsInvoiceNo,
                "spplrTin" => $salesHeader["kraPin"],
                "spplrBhfId" => null,
                "spplrNm" => $salesHeader["name"],
                "spplrInvcNo" => null,
                "regTyCd" => "M",//A = Automatic, M = Manual
                "pchsTyCd" => "N",//N = normal
                "rcptTyCd" => $rcptTyCd, //P = Purchase, R = Credit Note after purchase
                "pmtTyCd" => "01",
                "pchsSttsCd" => "02",
                "cfmDt" => $cfmDt,
                "pchsDt" => $pchsDt,
                "wrhsDt" => "",
                "cnclReqDt" => "",
                "cnclDt" => "",
                "rfdDt" => "",
                "totItemCnt" => count($purchaseLines), 
                "taxblAmtA" => kuzaRound($taxblAmtA,2),
                "taxblAmtB" => kuzaRound($taxblAmtB,2),
                "taxblAmtC" => kuzaRound($taxblAmtC,2),
                "taxblAmtD" => kuzaRound($taxblAmtD,2),
                "taxblAmtE" => kuzaRound($taxblAmtE,2),
                "taxRtA" => $taxRtA, 
                "taxRtB" => $taxRtB,
                "taxRtC" => $taxRtC,
                "taxRtD" => $taxRtD,
                "taxRtE" => $taxRtE,
                "taxAmtA" => kuzaRound($taxAmtA,2),
                "taxAmtB" => kuzaRound($taxAmtB,2),
                "taxAmtC" => kuzaRound($taxAmtC,2),
                "taxAmtD" => kuzaRound($taxAmtD,2),
                "taxAmtE" => kuzaRound($taxAmtE,2),
                "totTaxblAmt" => kuzaRound($totTaxblAmt,2), 
                "totTaxAmt" => kuzaRound($totTaxAmt,2),
                "totAmt" => kuzaRound($totAmt,2),
                "remark" => null,
                "regrNm" => "Admin",
                "regrId" => "Admin",
                "modrNm" => "Admin",
                "modrId" => "Admin",
                "itemList" =>  $itemList
     ];
     //echo json_encode($postData);
     //$response = sendToEtims("trnsPurchase/savePurchases",$postData);
     $response = stageRequest("trnsPurchase/savePurchases",$postData);
     
     
     return $response;
}
function stockIO($branchId, $sarNo,$orgSarNo, $regTypeCd,$custTin, $custNm,$custBhfId,$sarTypeCd,$occurenceDate,$lines){
    $response = array();
    $totTaxblAmt =0;
    $totTaxAmt =0;
    $totAmt =0;
    $itemList = array();
    $sequence=1;
    foreach($lines as $line){
        $taxGroup = $line["taxGroup"];
        $lineTotal = kuzaRound($line["totalAmount"],2);
        $lineVat = kuzaRound($line["totalVAT"],2);
        $totTaxblAmt+=$lineTotal;
        $totAmt+=$lineTotal;
        $totTaxAmt+=$lineVat;
        $listEntry =  [
                "itemSeq"=> $sequence,
                "itemCd" =>  $line["itemNo"],
                "itemClsCd"=>  $line["item_class"],
                "itemNm"=>  $line["description"],
                "bcd"=>  $line["upcCode"],
                "pkgUnitCd"=>  $line["packaging_unit"],
                "pkg"=>  $line["quantity"],
                "qtyUnitCd"=>  $line["unitOfMeasure"], 
                "qty"=>  $line["quantity"], 
                "itemExprDt"=>  null,
                "prc"=>  kuzaRound($line["unitPrice"],2),
                "splyAmt"=>  kuzaRound($lineTotal,2),
                "totDcAmt"=>  kuzaRound(0,2),//what is this??
                "taxblAmt"=>  kuzaRound($lineTotal,2),
                "taxTyCd"=>  $line["taxGroup"], 
                "taxAmt"=>  kuzaRound($lineVat,2),
                "totAmt"=>  kuzaRound($lineTotal,2),

                ];
            array_push($itemList,$listEntry);
        $sequence++;
    }
    $date = new DateTime($occurenceDate);
    $occurDT = $date->format('Ymd');
     $postData= [
                "tin" => getKRAPIN(),
                "bhfId" => $branchId,
                "sarNo" => $sarNo,
                "sarNo" => $sarNo,
                "orgSarNo" => $orgSarNo,
                "orgSarNo" => $orgSarNo,
                "regTyCd" => $regTypeCd,
                "custTin" => $custTin,
                "custNm" => $custNm,
                "custBhfId" => $custBhfId,
                "sarTyCd" => $sarTypeCd,
                "ocrnDt" => $occurDT,
                "totItemCnt" => count($lines), 
                "totTaxblAmt" => kuzaRound($totTaxblAmt,2), 
                "totTaxAmt" => kuzaRound($totTaxAmt,2),
                "totAmt" => kuzaRound($totAmt,2),
                "remark" => null,
                "regrNm" => "Admin",
                "regrId" => "Admin",
                "modrNm" => "Admin",
                "modrId" => "Admin",
                "itemList" =>  $itemList
     ];
    // echo json_encode($postData);
     //$response = sendToEtims("stock/saveStockItems",$postData);
     //print_r($response);
     stageRequest("stock/saveStockItems",$postData);
     return $response;
}
function stageRequest($link,$postData){
    //$response =sendToEtims($link,$postData);
    $sql = "INSERT INTO `pending_etims_requests`(`link`, `request`, `status`, `added_on`) VALUES (?,?,?,NOW())";
    $values = array($link,json_encode($postData),"Pending");
    pdoExecute($sql,$values);
    return array();
}
function sendToEtims($link,$postData){
    $etimsServer = getEtimsLink();
   // $etimsServer = "http://162.213.255.140:8088/";
    $chKns = curl_init();
    //echo "Am initilizing";
    //print_r($postData);
        $headers  = ['Content-Type: application/json'];
        curl_setopt($chKns, CURLOPT_URL,$etimsServer.$link);
        curl_setopt($chKns, CURLOPT_POST, 1);
        curl_setopt($chKns, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($chKns, CURLOPT_POSTFIELDS, json_encode($postData));           
        curl_setopt($chKns, CURLOPT_HTTPHEADER, $headers);
        $result     = curl_exec ($chKns);
        $statusCode = curl_getinfo($chKns, CURLINFO_HTTP_CODE);
        curl_close($chKns);
        //echo $result;

        pdoExecute("INSERT INTO `etims_logs`(`link`, `request_body`, `response`, `added_on`) VALUES (?,?,?,NOW())",array($link,json_encode($postData),$result));
        $response = json_decode($result,true);
        return $response;
}
function getKRAPIN(){
    return getEtimsDetails()["kra_pin"];//"P000000119A";

}
function getDeviceSerial(){
    return getEtimsDetails()["serial_no"];//"asenkaVSCU00";
}
function getBranchId(){
    return getEtimsDetails()["branch_id"];
}
function getEtimsLink(){
    return getEtimsDetails()["etims_server"];
}
function getDefaultPostBody($branchId,$serialNo){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' => $branchId,
                'dvcSrlNo' =>  $serialNo
            ];
            return $postData;
}
function getDefaultPostBodyWithDate($branchId){
    $postData= [
                'tin' => getKRAPIN(),
                'bhfId' =>$branchId,
                'lastReqDt' => '20180520000000'
            ];
            return $postData;
}
function kuzaRound($numberInput,$decimalPlaces){
    $myNumber = number_format($numberInput,$decimalPlaces);
    return str_ireplace(",","",$myNumber);

}